/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component;

import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.component.NamedComponentDetails;
import com.sonatype.clm.dto.model.ide.ComponentVersionInfo;
import com.sonatype.insight.ide.eclipse.Activator;
import com.sonatype.insight.ide.eclipse.internal.ArtifactKey;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.rest.InsightClientManager;
import com.sonatype.insight.ide.eclipse.internal.rest.UrlBuilder;
import com.sonatype.insight.ide.eclipse.internal.rest.UserInteraction;
import com.sonatype.insight.ide.eclipse.internal.ui.Controller;
import com.sonatype.insight.ide.eclipse.internal.ui.ProjectAssociationDialog;
import com.sonatype.insight.ide.eclipse.internal.ui.component.SWTComponentInformationComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.details.ComponentDetailsEditorPart;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentDetailsLoader;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentDetailsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentVersionDetailsLoader;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentVersionDetailsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.edit.DependencyUpdateWizard;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.ComparableVersion;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Objects;
import org.apache.http.client.HttpResponseException;
import org.apache.http.conn.HttpHostConnectException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentInformationController
implements Controller.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentInformationController.class);
    public static final String CONFIG_LINK = "CONFIG";
    public static final String SUPPORT_LINK = "SUPPORT";
    private ComponentVersionDetailsLoader componentVersionLoader;
    private ComponentDetailsLoader componentDetailsLoader;
    private volatile UIDependencyElement selectedComponent;
    private ComponentDetailsModel selectedComponentVersion;
    private ComponentDetailsModel selectedVersion;
    private Controller controller;
    private SWTComponentInformationComposite componentInformation;

    public ComponentInformationController(Controller controller, SWTComponentInformationComposite componentInformation) {
        this.controller = controller;
        this.componentInformation = componentInformation;
    }

    @Override
    public void elementChanged(Controller.ListenerEvent event) {
        if (event == null) {
            return;
        }
        if (event.getType() == Controller.Type.SELECTED) {
            UIDependencyElement elem = this.getDependencyElement(event);
            if (elem != null && !elem.equals(this.selectedComponent)) {
                this.loadComponentVersions(elem);
            }
        } else if (event.getType() == Controller.Type.UPDATED) {
            UIDependencyElement elem = this.getDependencyElement(event);
            if (this.isComponentVersionUpdated(elem)) {
                this.runOnUIThread(this::clearComponentInfo);
            }
        } else if (event.getType() == Controller.Type.SERVER_CHANGED || event.getType() == Controller.Type.NEW_PROVIDER) {
            this.runOnUIThread(this::clearComponentInfo);
        } else if (event.getType() == Controller.Type.PROJECTS_ADDED || event.getType() == Controller.Type.PROJECTS_REMOVED || event.getType() == Controller.Type.ACTIVE_PROJECTS_CHANGED) {
            this.runOnUIThread(() -> {
                if (this.componentInformation.isErrorMessageVisible()) {
                    return;
                }
                this.clearComponentInfo();
            });
        } else if (event.getType() == Controller.Type.SERVER_FAILED) {
            this.runOnUIThread(this.componentInformation::showErrorMessage);
        }
    }

    private boolean isComponentVersionUpdated(UIDependencyElement updated) {
        ArtifactKey selectedComponentArtifactKey;
        if (updated == null || this.selectedComponent == null) {
            return false;
        }
        ArtifactKey artifactKey = updated.getMavenArtifactKey();
        if (artifactKey.isSameGav(selectedComponentArtifactKey = this.selectedComponent.getMavenArtifactKey())) {
            return false;
        }
        if (this.areSameComponent(artifactKey, selectedComponentArtifactKey)) {
            return !artifactKey.getVersion().equals(selectedComponentArtifactKey.getVersion());
        }
        return false;
    }

    private boolean areSameComponent(ArtifactKey one, ArtifactKey two) {
        return two != null && Objects.equals(one.getGroupId(), two.getGroupId()) && Objects.equals(one.getArtifactId(), two.getArtifactId());
    }

    private UIDependencyElement getDependencyElement(Controller.ListenerEvent event) {
        if (event.getElements(UIDependencyElement.class) != null && !event.getElements(UIDependencyElement.class).isEmpty()) {
            return event.getElements(UIDependencyElement.class).toArray(new UIDependencyElement[1])[0];
        }
        return null;
    }

    private void loadComponentVersions(UIDependencyElement element) {
        this.selectedVersion = null;
        this.selectedComponentVersion = null;
        this.selectedComponent = element;
        this.runOnUIThread(() -> this.componentInformation.showInformationMesssage(Messages.ComponentInformationController_loadingMessage));
        this.runOnUIThread(this::loadComponentVersions);
    }

    private void runOnUIThread(Runnable runnable) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }

    private void loadComponentVersions() {
        try {
            ComponentIdentifier identifier = this.getIdentifierFromElement();
            ComponentVersionInfo allVersionsInfo = InsightClientManager.getInstance().getClient().getComponentVersionInfo(this.selectedComponent.getApplicationId(), identifier);
            this.componentVersionLoader = new ComponentVersionDetailsLoader(allVersionsInfo, identifier);
            this.componentInformation.loadComponentVersions(this.componentVersionLoader);
        }
        catch (HttpResponseException e) {
            this.serverUnreachable(e.getStatusCode(), Messages.DependencyContentProvider_genericError, e);
        }
        catch (HttpHostConnectException e) {
            this.serverUnreachable(0, Messages.DependencyContentProvider_hostError, e);
        }
        catch (IOException e) {
            this.serverUnreachable(0, Messages.DependencyContentProvider_unknownError, e);
        }
        catch (URISyntaxException e) {
            this.serverUnreachable(0, NLS.bind((String)Messages.DependencyContentProvider_IncorrectAddress, (Object)InsightClientManager.getInstance().getServerUrl()), e);
        }
    }

    private ComponentIdentifier getIdentifierFromElement() {
        ArtifactKey key = this.selectedComponent.getDeclaredArtifactKey();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("artifactId", key.getArtifactId());
        properties.put("groupId", key.getGroupId());
        properties.put("version", key.getVersion());
        properties.put("classifier", key.getClassifier());
        properties.put("extension", key.getExtension());
        return new ComponentIdentifier("maven", properties);
    }

    private void serverUnreachable(int code, String msg, Throwable e) {
        this.componentInformation.showErrorMessage();
        this.controller.notifyServerFailed(code, msg);
        LOG.error("Cannot get the component details: {}. Status code: {}. With error: ", new Object[]{msg, code, e.getMessage()});
    }

    private void clearComponentInfo() {
        this.selectedComponent = null;
        int activeProjects = this.controller.getCache().getActiveProjects().length;
        int assignedProjects = this.controller.getCache().getAssignedProjectsSize();
        if (activeProjects > 0) {
            this.componentInformation.showInformationMesssage(Messages.ComponentInformationController_selectComponentMessage);
            return;
        }
        if (assignedProjects > 0 && activeProjects <= 0) {
            this.componentInformation.showInformationMesssage(Messages.ComponentInformationController_projectsFilteredMessage);
            return;
        }
        this.componentInformation.showNoOpenProjectsMessage();
    }

    public void selectVersionOnTable(String version) {
        if (this.componentVersionLoader == null || this.componentVersionLoader.getComponentVersions().isEmpty()) {
            return;
        }
        this.componentInformation.selectVersion(this.componentVersionLoader.getComponentByVersion(version));
    }

    public void loadDetailsForVersion(ComponentVersionDetailsModel data) {
        if (this.selectedVersion != null) {
            if (this.selectedVersion.getVersion().equals(data.getVersion())) {
                return;
            }
            InsightClientManager.getInstance().getUserInteractionCountMap().get((Object)UserInteraction.VERSION_HISTORY_CLICKED).incrementAndGet();
        }
        this.runOnUIThread(() -> this.componentInformation.showInformationMesssageOnDetailsPanel(Messages.ComponentInformationController_loadingMessage));
        this.runOnUIThread(() -> this.loadComponentDetails(data));
    }

    private void loadComponentDetails(ComponentVersionDetailsModel data) {
        try {
            ComponentIdentifier identifier = this.getIdentifierFromElement().createAlternativeVersion(data.getVersion());
            NamedComponentDetails namedComponentDetails = InsightClientManager.getInstance().getClient().getComponentDetails(this.selectedComponent.getApplicationId(), identifier, null, null, false);
            this.componentDetailsLoader = new ComponentDetailsLoader(namedComponentDetails);
            this.selectedVersion = this.componentDetailsLoader.getComponentDetails();
            this.selectedVersion.setInUse(data.isInUse());
            this.selectedVersion.setIsTransitive(this.selectedComponent.isTransitive());
            this.componentInformation.updateComponentDetails(this.selectedVersion);
            if (this.getIdentifierFromElement().equals((Object)this.selectedVersion.getComponentIdentifier())) {
                this.selectedComponentVersion = this.componentDetailsLoader.getComponentDetailsCopy();
            }
        }
        catch (HttpResponseException e) {
            this.serverUnreachable(e.getStatusCode(), Messages.DependencyContentProvider_genericError, e);
        }
        catch (HttpHostConnectException e) {
            this.serverUnreachable(0, Messages.DependencyContentProvider_hostError, e);
        }
        catch (IOException e) {
            this.serverUnreachable(0, Messages.DependencyContentProvider_unknownError, e);
        }
        catch (URISyntaxException e) {
            this.serverUnreachable(0, NLS.bind((String)Messages.DependencyContentProvider_IncorrectAddress, (Object)InsightClientManager.getInstance().getServerUrl()), e);
        }
    }

    public void openSelectedVersionDetails() {
        ComponentDetailsEditorPart.open(this.selectedVersion, this);
    }

    public void openSelectedComponetVersionDetails() {
        ComponentDetailsEditorPart.open(this.selectedComponentVersion, this);
    }

    public void migrateToSelectedVersion() {
        InsightClientManager.getInstance().getUserInteractionCountMap().get((Object)UserInteraction.MIGRATION_PERFORMED).incrementAndGet();
        this.selectedComponent.setUpdateVersion(new ComparableVersion(this.selectedVersion.getVersion()));
        DependencyUpdateWizard.open(this.selectedComponent, this.controller);
    }

    public void handleLink(String link) {
        if (CONFIG_LINK.equals(link)) {
            ProjectAssociationDialog dialog = new ProjectAssociationDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.controller);
            dialog.open();
            return;
        }
        if (SUPPORT_LINK.equals(link)) {
            Activator.openUrl(Messages.ComponentInformationController_supportLink, true);
        }
    }

    public void handleProblemCodeLink(String code) {
        String serverUrl = InsightClientManager.getInstance().getServerUrl();
        UrlBuilder url = new UrlBuilder(serverUrl);
        url.appendPath("#/vulnerabilities");
        url.appendPath(code);
        Activator.openUrl(url.build(), true);
    }
}

