/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component;

import com.sonatype.insight.ide.eclipse.internal.ui.StylesUtils;
import com.sonatype.insight.ide.eclipse.internal.ui.component.BaseComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.ComponentInformationController;
import com.sonatype.insight.ide.eclipse.internal.ui.component.details.SelectedVersionComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.messages.ErrorMessageComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.messages.InformationMessageComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.messages.NoOpenProjectsMessageComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentDetailsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentVersionDetailsLoader;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentVersionDetailsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.versions.VersionHistoryComposite;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class SWTComponentInformationComposite
extends BaseComposite {
    private static final int SASH_SPLITTER_WIDTH = 12;
    private SashForm divSashForm;
    private VersionHistoryComposite versionHistoryComposite;
    private SelectedVersionComposite selectedComponentComposite;
    private ErrorMessageComposite errorMessageComposite;
    private InformationMessageComposite infoMessageComposite;
    private NoOpenProjectsMessageComposite noOpenProjectsMessageComposite;

    public SWTComponentInformationComposite(Composite parent, int style) {
        super(parent, style);
        this.createComponentInformationPanel();
        this.createErrorMessage();
        this.createInformationMessage();
        this.createNoOpenProjectsMessage();
    }

    private void createComponentInformationPanel() {
        this.divSashForm = new SashForm((Composite)this, 256);
        this.divSashForm.setSashWidth(12);
        GridData layout_data = new GridData(4, 4, true, true, 1, 1);
        layout_data.exclude = true;
        this.divSashForm.setLayoutData((Object)layout_data);
        this.divSashForm.setVisible(false);
        this.createVersionHistoryPanel();
        this.createComponentDetailsPanel();
    }

    private void createVersionHistoryPanel() {
        this.versionHistoryComposite = new VersionHistoryComposite((Composite)this.divSashForm, 0);
        this.versionHistoryComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
    }

    private void createComponentDetailsPanel() {
        this.selectedComponentComposite = new SelectedVersionComposite((Composite)this.divSashForm, 0);
        this.selectedComponentComposite.setLayoutData(new GridData(4, 128, true, true, 1, 1));
    }

    private void createErrorMessage() {
        this.errorMessageComposite = new ErrorMessageComposite(this, 0);
        GridData layout_data = new GridData(4, 4, true, true, 1, 1);
        layout_data.exclude = true;
        this.errorMessageComposite.setLayoutData(layout_data);
        this.errorMessageComposite.setVisible(false);
        StylesUtils.updateBackgroundColor(this.errorMessageComposite);
    }

    private void createInformationMessage() {
        this.infoMessageComposite = new InformationMessageComposite(this, 0);
        GridData layout_data = new GridData(4, 4, true, true, 1, 1);
        layout_data.exclude = true;
        this.infoMessageComposite.setLayoutData(layout_data);
        this.infoMessageComposite.setVisible(false);
        StylesUtils.updateBackgroundColor(this.infoMessageComposite);
    }

    private void createNoOpenProjectsMessage() {
        this.noOpenProjectsMessageComposite = new NoOpenProjectsMessageComposite(this, 0);
        GridData layout_data = new GridData(4, 4, true, true, 1, 1);
        layout_data.exclude = true;
        this.noOpenProjectsMessageComposite.setLayoutData(layout_data);
        this.noOpenProjectsMessageComposite.setVisible(false);
        StylesUtils.updateBackgroundColor(this.noOpenProjectsMessageComposite);
    }

    boolean isErrorMessageVisible() {
        return this.errorMessageComposite.isVisible();
    }

    void loadComponentVersions(ComponentVersionDetailsLoader dataProvider) {
        this.checkWidget();
        this.hideComposite(this.errorMessageComposite);
        this.hideComposite(this.infoMessageComposite);
        this.hideComposite(this.noOpenProjectsMessageComposite);
        this.showComposite((Composite)this.divSashForm);
        this.versionHistoryComposite.loadRemediations(dataProvider);
        this.versionHistoryComposite.loadComponentVersions(dataProvider);
        this.layout();
    }

    void selectVersion(ComponentVersionDetailsModel componentVersion) {
        this.checkWidget();
        this.versionHistoryComposite.setSelectVersion(componentVersion);
    }

    void showErrorMessage() {
        this.checkWidget();
        this.hideComposite((Composite)this.divSashForm);
        this.hideComposite(this.infoMessageComposite);
        this.hideComposite(this.noOpenProjectsMessageComposite);
        this.showComposite(this.errorMessageComposite);
        this.layout();
    }

    void showNoOpenProjectsMessage() {
        this.checkWidget();
        this.hideComposite((Composite)this.divSashForm);
        this.hideComposite(this.infoMessageComposite);
        this.hideComposite(this.errorMessageComposite);
        this.showComposite(this.noOpenProjectsMessageComposite);
        this.layout();
    }

    void showInformationMesssage(String message) {
        this.checkWidget();
        this.hideComposite((Composite)this.divSashForm);
        this.hideComposite(this.errorMessageComposite);
        this.hideComposite(this.noOpenProjectsMessageComposite);
        this.showComposite(this.infoMessageComposite);
        this.infoMessageComposite.setInformationMessage(message);
        this.layout();
    }

    void updateComponentDetails(ComponentDetailsModel componentDetailsModel) {
        this.checkWidget();
        this.hideComposite(this.errorMessageComposite);
        this.hideComposite(this.noOpenProjectsMessageComposite);
        this.hideComposite(this.infoMessageComposite);
        this.selectedComponentComposite.setComponentDeatils(componentDetailsModel);
        this.layout();
    }

    void showInformationMesssageOnDetailsPanel(String message) {
        this.checkWidget();
        this.selectedComponentComposite.showInformationMesssage(message);
    }

    public void registerListeners(ComponentInformationController controller) {
        this.checkWidget();
        this.errorMessageComposite.registerListeners(controller);
        this.noOpenProjectsMessageComposite.registerListeners(controller);
        this.versionHistoryComposite.registerListeners(controller);
        this.selectedComponentComposite.registerListeners(controller);
    }
}

