/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.details;

import com.sonatype.insight.ide.eclipse.Images;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ui.StylesUtils;
import com.sonatype.insight.ide.eclipse.internal.ui.component.BaseComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.ComponentInformationController;
import com.sonatype.insight.ide.eclipse.internal.ui.component.details.tables.LicenseAnalysisTable;
import com.sonatype.insight.ide.eclipse.internal.ui.component.details.tables.PolicyViolationsTable;
import com.sonatype.insight.ide.eclipse.internal.ui.component.details.tables.SecurityIssuesTable;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentDetailsModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ComponentDetailsComposite
extends BaseComposite {
    private static final int SEPARATOR_HEIGHT = 25;
    private Composite policyViolationsComposite;
    private PolicyViolationsTable policyViolationsTable;
    private Composite licenseAnalysisComposite;
    private LicenseAnalysisTable licenseAnalysisTable;
    private Composite securityIssuesComposite;
    private SecurityIssuesTable securityIssuesTable;

    public ComponentDetailsComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout();
        StylesUtils.updateBackgroundColor(this);
        this.createPolicyViolationsTable();
        this.createEmptySeparator();
        this.createLicenseAnalysisTable();
        this.createEmptySeparator();
        this.createSecurityIssuesTable();
    }

    protected void setLayout() {
        GridLayout gl_parent = new GridLayout(1, true);
        gl_parent.verticalSpacing = 0;
        gl_parent.marginWidth = 25;
        gl_parent.marginHeight = 25;
        gl_parent.horizontalSpacing = 0;
        this.setLayout((Layout)gl_parent);
    }

    private void createPolicyViolationsTable() {
        this.createHeader(Messages.ComponentDetailsComposite_policyViolationsHeader, Images.getImage("policy-violations.png"));
        this.policyViolationsComposite = new Composite((Composite)this, 0);
        this.policyViolationsComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.policyViolationsTable = new PolicyViolationsTable(this.policyViolationsComposite);
    }

    private void createLicenseAnalysisTable() {
        this.createHeader(Messages.ComponentDetailsComposite_licenseAnalysisHeader, Images.getImage("license-analysis.png"));
        this.licenseAnalysisComposite = new Composite((Composite)this, 0);
        this.licenseAnalysisComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.licenseAnalysisTable = new LicenseAnalysisTable(this.licenseAnalysisComposite);
    }

    private void createSecurityIssuesTable() {
        this.createHeader(Messages.ComponentDetailsComposite_securityIssuesHeader, Images.getImage("security-issues.png"));
        this.securityIssuesComposite = new Composite((Composite)this, 0);
        this.securityIssuesComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.securityIssuesTable = new SecurityIssuesTable(this.securityIssuesComposite);
    }

    private void createHeader(String text, Image image) {
        Composite headerComposite = new Composite((Composite)this, 0);
        headerComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        headerComposite.setLayout((Layout)new GridLayout(2, false));
        Label icon = new Label(headerComposite, 0);
        icon.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        icon.setImage(image);
        Label header = new Label(headerComposite, 0);
        header.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        header.setText(text);
        StylesUtils.updateBackgroundColor(headerComposite);
        StylesUtils.updateBackgroundColor((Control)header);
        StylesUtils.updateBackgroundColor((Control)icon);
        StylesUtils.makeBold((Control)header);
    }

    private void createEmptySeparator() {
        Label header = new Label((Composite)this, 0);
        GridData gl_data = new GridData(16384, 128, false, false, 1, 1);
        gl_data.heightHint = 25;
        header.setLayoutData((Object)gl_data);
    }

    public void loadComponentDetails(ComponentDetailsModel componentDetails) {
        this.checkWidget();
        this.policyViolationsTable.setPolicyViolations(componentDetails);
        this.licenseAnalysisTable.setLienseAnalysis(componentDetails);
        this.securityIssuesTable.setSecurityIssues(componentDetails);
        this.layout();
    }

    public void registerListeners(ComponentInformationController controller) {
        this.securityIssuesTable.registerListeners(controller);
    }
}

