/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.details;

import com.sonatype.insight.ide.eclipse.internal.ui.component.ComponentInformationController;
import com.sonatype.insight.ide.eclipse.internal.ui.component.details.ComponentDetailsComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.details.ComponentDetailsInput;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentDetailsModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class ComponentDetailsEditorPart
extends EditorPart {
    private static final String ID = ComponentDetailsEditorPart.class.getName();
    private ScrolledComposite scrolledDetails;
    private ComponentDetailsComposite componentDetailsComposite;
    private ComponentDetailsModel details;
    private ComponentInformationController controller;

    public static void open(ComponentDetailsModel componentDetails, ComponentInformationController controller) {
        IWorkbenchPage page;
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                ComponentDetailsInput input = new ComponentDetailsInput(componentDetails, controller);
                IEditorPart editor = page.findEditor((IEditorInput)input);
                if (editor != null) {
                    page.activate((IWorkbenchPart)editor);
                } else {
                    page.openEditor((IEditorInput)input, ID);
                }
            }
            catch (PartInitException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void createPartControl(Composite parent) {
        ComponentDetailsInput input = (ComponentDetailsInput)this.getEditorInput();
        this.details = input.getDetails();
        this.controller = input.getController();
        this.setPartName(input.getName());
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createScrollPanel(parent);
        this.createComponentDetailsPanel();
        this.addScrollBarToDetailsPanel();
        this.addDisposeListener(parent);
        this.updateScrollSize();
        this.componentDetailsComposite.layout();
        parent.layout();
    }

    private void createScrollPanel(Composite parent) {
        this.scrolledDetails = new ScrolledComposite(parent, 768);
        this.scrolledDetails.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    private void createComponentDetailsPanel() {
        this.componentDetailsComposite = new ComponentDetailsComposite((Composite)this.scrolledDetails, 0);
        this.componentDetailsComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.componentDetailsComposite.loadComponentDetails(this.details);
        this.componentDetailsComposite.registerListeners(this.controller);
    }

    private void addScrollBarToDetailsPanel() {
        this.scrolledDetails.setContent((Control)this.componentDetailsComposite);
        this.scrolledDetails.setExpandHorizontal(true);
        this.scrolledDetails.setExpandVertical(true);
        this.scrolledDetails.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ComponentDetailsEditorPart.this.updateScrollSize();
            }
        });
    }

    private void updateScrollSize() {
        Rectangle clientArea = this.scrolledDetails.getClientArea();
        clientArea.width -= this.scrolledDetails.getVerticalBar().getSize().x;
        Point minSize = this.scrolledDetails.getContent().computeSize(clientArea.width, -1);
        this.scrolledDetails.setMinSize(minSize);
    }

    private void addDisposeListener(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!ComponentDetailsEditorPart.this.scrolledDetails.isDisposed()) {
                    ComponentDetailsEditorPart.this.scrolledDetails.dispose();
                }
            }
        });
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof ComponentDetailsInput) {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
            return;
        }
        throw new PartInitException("Wrong editor input:" + String.valueOf(input.getClass()));
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }
}

