/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.details;

import com.sonatype.insight.ide.eclipse.internal.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;

public class LabelRow {
    private CLabel label;
    private CLabel value;

    public LabelRow(CLabel label, CLabel value) {
        if (label == null || value == null) {
            throw new IllegalArgumentException(Messages.LabelRow_validationError);
        }
        this.label = label;
        this.value = value;
    }

    public void setValue(String value) {
        this.value.setText(value);
    }

    public void setImage(Image image) {
        this.value.setImage(image);
    }

    public void setForeground(Color color) {
        this.value.setForeground(color);
    }

    public CLabel getValue() {
        return this.value;
    }

    public void hide() {
        this.hideControl((Control)this.label);
        this.hideControl((Control)this.value);
    }

    public void show() {
        this.showControl((Control)this.label);
        this.showControl((Control)this.value);
    }

    private void showControl(Control control) {
        if (control.isVisible()) {
            return;
        }
        GridData layout_data = (GridData)control.getLayoutData();
        layout_data.exclude = false;
        control.setVisible(true);
    }

    private void hideControl(Control control) {
        if (!control.isVisible()) {
            return;
        }
        GridData layout_data = (GridData)control.getLayoutData();
        layout_data.exclude = true;
        control.setVisible(false);
    }
}

