/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.details;

import com.sonatype.clm.dto.model.component.HygieneRating;
import com.sonatype.clm.dto.model.component.IntegrityRating;
import com.sonatype.insight.ide.eclipse.Images;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ui.StylesUtils;
import com.sonatype.insight.ide.eclipse.internal.ui.component.BaseComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.ComponentInformationController;
import com.sonatype.insight.ide.eclipse.internal.ui.component.details.ActionsComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.details.LabelRow;
import com.sonatype.insight.ide.eclipse.internal.ui.component.messages.InformationMessageComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentDetailsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ThreatLevelModel;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectedVersionComposite
extends BaseComposite {
    private static final String LABEL_SEPARATOR = ":";
    private LabelRow type;
    private LabelRow group;
    private LabelRow artifact;
    private LabelRow version;
    private LabelRow license;
    private LabelRow declaredLicense;
    private LabelRow observedLicense;
    private LabelRow effectiveLicense;
    private LabelRow highestPolicyThreat;
    private LabelRow highestCvssScore;
    private LabelRow integrityRating;
    private LabelRow hygieneRating;
    private LabelRow cataloged;
    private LabelRow matchState;
    private LabelRow identificationSource;
    private LabelRow category;
    private LabelRow website;
    private LabelRow identificationComment;
    private ActionsComposite actionsComposite;
    private Composite detailsComposite;
    private ScrolledComposite scrolledDetails;
    private InformationMessageComposite infoMessageComposite;

    public SelectedVersionComposite(Composite parent, int style) {
        super(parent, style);
        this.createComponentDetailsPane();
        this.createInformationMessage();
    }

    private void createComponentDetailsPane() {
        this.createTopPanel();
        this.createDetailsPanel();
    }

    private void createTopPanel() {
        this.actionsComposite = new ActionsComposite(this, 0);
        this.actionsComposite.setLayoutData(new GridData(4, 128, true, false, 1, 1));
    }

    private void createDetailsPanel() {
        this.createScrollPanel();
        this.detailsComposite = new Composite((Composite)this.scrolledDetails, 0);
        this.detailsComposite.setLayout((Layout)new GridLayout(2, false));
        this.detailsComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        StylesUtils.updateBackgroundColor(this.detailsComposite);
        this.type = this.createRowWithLabel(Messages.SelectedVersionComposite_typeLabel);
        this.group = this.createRowWithLabel(Messages.SelectedVersionComposite_groupLabel);
        this.artifact = this.createRowWithLabel(Messages.SelectedVersionComposite_artifactLabel);
        this.version = this.createRowWithLabel(Messages.SelectedVersionComposite_versionLabel);
        this.license = this.createRowWithLabel(Messages.SelectedVersionComposite_licenseLabel);
        this.declaredLicense = this.createRowWithLabel(Messages.SelectedVersionComposite_declaredLicenseLabel);
        this.observedLicense = this.createRowWithLabel(Messages.SelectedVersionComposite_observedLicenseLabel);
        this.effectiveLicense = this.createRowWithLabel(Messages.SelectedVersionComposite_effectiveLicenseLabel);
        this.highestPolicyThreat = this.createRowWithLabel(Messages.SelectedVersionComposite_highestPolicyThreatLabel);
        this.highestCvssScore = this.createRowWithLabel(Messages.SelectedVersionComposite_highestCvssScoreLabel);
        this.integrityRating = this.createRowWithLabel(Messages.SelectedVersionComposite_integrityRatingLabel);
        this.hygieneRating = this.createRowWithLabel(Messages.SelectedVersionComposite_hygieneRatingLabel);
        this.cataloged = this.createRowWithLabel(Messages.SelectedVersionComposite_catalogedLabel);
        this.matchState = this.createRowWithLabel(Messages.SelectedVersionComposite_matchStateLabel);
        this.identificationSource = this.createRowWithLabel(Messages.SelectedVersionComposite_identificationSourceLabel);
        this.category = this.createRowWithLabel(Messages.SelectedVersionComposite_categoryLabel);
        this.website = this.createRowWithLabel(Messages.SelectedVersionComposite_websiteLabel);
        this.identificationComment = this.createRowWithLabel(Messages.SelectedVersionComposite_identificationCommentLabel);
        this.addScrollBarToDetailsPanel();
    }

    private LabelRow createRowWithLabel(String labelText) {
        CLabel label = this.createLabel();
        label.setText(labelText + LABEL_SEPARATOR);
        CLabel value = this.createValue();
        StylesUtils.makeBold((Control)value);
        return new LabelRow(label, value);
    }

    private CLabel createLabel() {
        CLabel label = new CLabel(this.detailsComposite, 0);
        label.setAlignment(131072);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        StylesUtils.updateBackgroundColor((Composite)label);
        return label;
    }

    private CLabel createValue() {
        CLabel value = new CLabel(this.detailsComposite, 0);
        value.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        StylesUtils.updateForegroundColor((Control)value);
        StylesUtils.updateBackgroundColor((Composite)value);
        return value;
    }

    private void createScrollPanel() {
        this.scrolledDetails = new ScrolledComposite((Composite)this, 768);
        GridData layout_data = new GridData(4, 4, true, true, 1, 1);
        layout_data.exclude = true;
        this.scrolledDetails.setLayoutData((Object)layout_data);
        this.scrolledDetails.setVisible(false);
    }

    private void addScrollBarToDetailsPanel() {
        this.scrolledDetails.setContent((Control)this.detailsComposite);
        this.scrolledDetails.setExpandHorizontal(true);
        this.scrolledDetails.setExpandVertical(true);
        this.scrolledDetails.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SelectedVersionComposite.this.updateScrollSize();
            }
        });
    }

    private void updateScrollSize() {
        this.detailsComposite.pack();
        int width = this.detailsComposite.getSize().x;
        this.scrolledDetails.setMinSize(this.detailsComposite.computeSize(width, -1));
    }

    private void createInformationMessage() {
        this.infoMessageComposite = new InformationMessageComposite(this, 0);
        GridData layout_data = new GridData(4, 4, true, true, 1, 1);
        layout_data.exclude = true;
        this.infoMessageComposite.setLayoutData(layout_data);
        this.infoMessageComposite.setVisible(false);
    }

    public void showInformationMesssage(String message) {
        this.checkWidget();
        this.hideComposite((Composite)this.scrolledDetails);
        this.showComposite(this.infoMessageComposite);
        this.infoMessageComposite.setInformationMessage(message);
        this.layout(true);
    }

    public void setComponentDeatils(ComponentDetailsModel componentDetailsModel) {
        this.checkWidget();
        this.hideComposite(this.infoMessageComposite);
        this.showComposite((Composite)this.scrolledDetails);
        this.type.setValue(componentDetailsModel.getType());
        this.group.setValue(componentDetailsModel.getGroup());
        this.artifact.setValue(componentDetailsModel.getArtifact());
        this.version.setValue(componentDetailsModel.getVersion());
        this.effectiveLicense.setValue(componentDetailsModel.getEffectiveLicense());
        this.cataloged.setValue(componentDetailsModel.getCataloged());
        this.identificationSource.setValue(componentDetailsModel.getIdentificationSource());
        this.category.setValue(componentDetailsModel.getCategory());
        this.setHighestPolicyThreat(componentDetailsModel);
        this.setHighestCvssScore(componentDetailsModel);
        this.setLicense(componentDetailsModel);
        this.setValueIfPresent(this.website, componentDetailsModel.getWebsite());
        this.setValueIfPresent(this.identificationComment, componentDetailsModel.getIdentificationComment());
        this.setValueIfPresent(this.matchState, componentDetailsModel.getMatchState());
        this.setIntegrityRating(componentDetailsModel.getIntegrityRating());
        this.setHygieneRating(componentDetailsModel.getHygieneRating());
        this.actionsComposite.disableMigrateToSelectedButton(componentDetailsModel.isInUse() || componentDetailsModel.isTransitive());
        this.updateScrollSize();
        this.detailsComposite.layout();
        this.layout();
    }

    private void setHighestPolicyThreat(ComponentDetailsModel componentDetailsModel) {
        String policyThreat = componentDetailsModel.getHighestPolicyThreat();
        if ("NA".equals(policyThreat)) {
            this.highestPolicyThreat.setValue(policyThreat);
            this.highestPolicyThreat.setImage(null);
            return;
        }
        ThreatLevelModel threatLevel = ThreatLevelModel.getValue(Integer.valueOf(policyThreat));
        this.highestPolicyThreat.setImage(threatLevel.getIcon());
        this.highestPolicyThreat.setValue(String.format("%s within %s policies", policyThreat, componentDetailsModel.getPolicyCount()));
    }

    private void setHighestCvssScore(ComponentDetailsModel componentDetailsModel) {
        String cvssScore = componentDetailsModel.getHighestCvssScore();
        if (componentDetailsModel.isManual()) {
            this.highestCvssScore.setValue(Messages.SelectedVersionComposite_manualIdentificationSource);
            this.highestCvssScore.setImage(null);
            return;
        }
        if ("NA".equals(cvssScore)) {
            this.highestCvssScore.setValue(cvssScore);
            this.highestCvssScore.setImage(null);
            return;
        }
        ThreatLevelModel threatLevel = ThreatLevelModel.getValue(Float.valueOf(cvssScore).intValue());
        this.highestCvssScore.setImage(threatLevel.getIcon());
        this.highestCvssScore.setValue(String.format("%s within %s security issues", cvssScore, componentDetailsModel.getSecurityIssuesCount()));
    }

    private void setLicense(ComponentDetailsModel componentDetailsModel) {
        if (componentDetailsModel.isManual()) {
            this.declaredLicense.hide();
            this.observedLicense.hide();
            this.license.show();
            this.license.setValue(Messages.SelectedVersionComposite_manualIdentificationSource);
            return;
        }
        this.declaredLicense.show();
        this.observedLicense.show();
        this.license.hide();
        this.declaredLicense.setValue(componentDetailsModel.getDeclaredLicense());
        this.observedLicense.setValue(componentDetailsModel.getObservedLicense());
    }

    private void setIntegrityRating(IntegrityRating integrityRating) {
        if (integrityRating == null) {
            this.setValueIfPresent(this.integrityRating, "");
            return;
        }
        this.setValueIfPresent(this.integrityRating, integrityRating.getLabel());
    }

    private void setHygieneRating(HygieneRating hygieneRating) {
        if (hygieneRating == null) {
            this.setValueIfPresent(this.hygieneRating, "");
            return;
        }
        this.hygieneRating.setImage(null);
        if (hygieneRating.getId() == 1) {
            this.hygieneRating.setImage(Images.getImage("exemplar.png"));
        }
        if (hygieneRating.getId() == 4) {
            this.hygieneRating.setImage(Images.getImage("laggard.png"));
        }
        this.setValueIfPresent(this.hygieneRating, hygieneRating.getLabel());
    }

    private void setValueIfPresent(LabelRow row, String value) {
        if (StringUtils.isEmpty((String)value)) {
            row.hide();
            return;
        }
        row.setValue(value);
        row.show();
    }

    public void registerListeners(ComponentInformationController controller) {
        this.checkWidget();
        this.actionsComposite.registerListeners(controller);
    }
}

