/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.details.tables;

import com.sonatype.insight.ide.eclipse.internal.ui.StylesUtils;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BaseTable {
    protected final Composite parent;
    private static final Color SEPARATOR_COLOR = Display.getCurrent().getSystemColor(15);

    public BaseTable(Composite parent) {
        this.parent = parent;
        this.parent.setLayout((Layout)new GridLayout(10, true));
        StylesUtils.updateBackgroundColor(this.parent);
    }

    protected void addMessage(String message) {
        Label label = new Label(this.parent, 0);
        label.setText(message);
        label.setLayoutData((Object)new GridData(4, 128, true, true, 10, 1));
        StylesUtils.updateBackgroundColor((Control)label);
    }

    protected void addSeparator(int horizontalSpan) {
        GridData gl_data = new GridData(4, 128, true, false, horizontalSpan, 1);
        gl_data.heightHint = 1;
        final Label separator = new Label(this.parent, 0);
        separator.setLayoutData((Object)gl_data);
        separator.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setForeground(SEPARATOR_COLOR);
                gc.drawLine(0, 0, separator.getBounds().width, 0);
            }
        });
    }
}

