/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.details.tables;

import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ui.StylesUtils;
import com.sonatype.insight.ide.eclipse.internal.ui.component.details.tables.BaseTable;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentDetailsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.LicenseAnalysisModel;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class LicenseAnalysisTable
extends BaseTable {
    public LicenseAnalysisTable(Composite parent) {
        super(parent);
    }

    public void setLienseAnalysis(ComponentDetailsModel componentDetails) {
        if (componentDetails.isUnknown()) {
            this.addMessage(Messages.LicenseAnalysisTable_unknownComponentMessage);
            return;
        }
        if (componentDetails.isManual()) {
            this.addMessage(Messages.LicenseAnalysisTable_claimedComponentMessage);
            return;
        }
        List<LicenseAnalysisModel> licenseAnalysis = componentDetails.getLicenseAnalysis();
        if (licenseAnalysis == null || licenseAnalysis.isEmpty()) {
            this.addMessage(Messages.LicenseAnalysisTable_noLicenseAnalysisMessage);
            return;
        }
        LicenseAnalysisModel analysis = (LicenseAnalysisModel)licenseAnalysis.stream().findFirst().get();
        this.createHeaders(analysis);
        this.addData(analysis);
    }

    private void createHeaders(LicenseAnalysisModel analysis) {
        this.addSeparator(10);
        if (this.overridenLicencesPresent(analysis)) {
            this.createHeader(Messages.LicenseAnalysisTable_threatLevelColumn, 1);
            this.createHeader(Messages.LicenseAnalysisTable_overriddenLicensesColumn, 3);
            this.createHeader(Messages.LicenseAnalysisTable_declaredLicensesColumn, 3);
            this.createHeader(Messages.LicenseAnalysisTable_observedLicensesColumn, 3);
            return;
        }
        this.createHeader(Messages.LicenseAnalysisTable_threatLevelColumn, 2);
        this.createHeader(Messages.LicenseAnalysisTable_declaredLicensesColumn, 4);
        this.createHeader(Messages.LicenseAnalysisTable_observedLicensesColumn, 4);
    }

    private void createHeader(String text, int horizontalSpan) {
        Label header = new Label(this.parent, 0);
        header.setText(text);
        header.setLayoutData((Object)new GridData(4, 128, true, true, horizontalSpan, 1));
        StylesUtils.updateBackgroundColor((Control)header);
        StylesUtils.makeBold((Control)header);
    }

    public void addData(LicenseAnalysisModel analysis) {
        this.addSeparator(10);
        if (this.overridenLicencesPresent(analysis)) {
            this.addThreatLevel(analysis, 1);
            this.addOverriddenLicenses(analysis, 3);
            this.addDeclaredLicenses(analysis, 3);
            this.addObservedLicenses(analysis, 3);
            this.addSeparator(10);
            return;
        }
        this.addThreatLevel(analysis, 2);
        this.addDeclaredLicenses(analysis, 4);
        this.addObservedLicenses(analysis, 4);
        this.addSeparator(10);
    }

    private void addThreatLevel(LicenseAnalysisModel analysis, int horizontalSpan) {
        CLabel label = new CLabel(this.parent, 0);
        label.setImage(analysis.getLicenseThreatLevel().getIcon());
        label.setText(analysis.getGroupNames());
        label.setLayoutData((Object)new GridData(4, 4, true, true, horizontalSpan, 1));
        StylesUtils.updateBackgroundColor((Composite)label);
    }

    private void addOverriddenLicenses(LicenseAnalysisModel analysis, int horizontalSpan) {
        Label label = new Label(this.parent, 64);
        label.setText(analysis.getOverriddenLicenses());
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true, horizontalSpan, 1));
        StylesUtils.updateBackgroundColor((Control)label);
    }

    private void addDeclaredLicenses(LicenseAnalysisModel analysis, int horizontalSpan) {
        Label label = new Label(this.parent, 64);
        label.setText(analysis.getDeclaredLicenses());
        label.setLayoutData((Object)new GridData(1, 0x1000000, true, true, horizontalSpan, 1));
        StylesUtils.updateBackgroundColor((Control)label);
    }

    private void addObservedLicenses(LicenseAnalysisModel analysis, int horizontalSpan) {
        Label label = new Label(this.parent, 64);
        label.setText(analysis.getObservedLicenses());
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true, horizontalSpan, 1));
        StylesUtils.updateBackgroundColor((Control)label);
    }

    private boolean overridenLicencesPresent(LicenseAnalysisModel analysis) {
        String overridenLicenses = analysis.getOverriddenLicenses();
        return StringUtils.isNotEmpty((String)overridenLicenses) && !"-".equals(overridenLicenses);
    }
}

