/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.details.tables;

import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ui.StylesUtils;
import com.sonatype.insight.ide.eclipse.internal.ui.component.details.tables.BaseTable;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentDetailsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.PolicyViolationsModel;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class PolicyViolationsTable
extends BaseTable {
    public PolicyViolationsTable(Composite parent) {
        super(parent);
    }

    public void setPolicyViolations(ComponentDetailsModel componentDetails) {
        List<PolicyViolationsModel> policyViolations = componentDetails.getPolicyViolations();
        if (policyViolations == null || policyViolations.isEmpty()) {
            this.addMessage(Messages.PolicyViolationsTable_noPolicyViolationssMessage);
            return;
        }
        this.createHeaders();
        this.addData(policyViolations);
    }

    private void createHeaders() {
        this.addSeparator(10);
        this.createHeader(Messages.PolicyViolationsTable_policyColumn, 2);
        this.createHeader(Messages.PolicyViolationsTable_constraintColumn, 2);
        this.createHeader(Messages.PolicyViolationsTable_summaryColumn, 6);
    }

    private void createHeader(String text, int horizontalSpan) {
        Label header = new Label(this.parent, 0);
        header.setText(text);
        header.setLayoutData((Object)new GridData(4, 128, true, true, horizontalSpan, 1));
        StylesUtils.updateBackgroundColor((Control)header);
        StylesUtils.makeBold((Control)header);
    }

    private void addData(List<PolicyViolationsModel> policyViolations) {
        Map policyViolationsMap = policyViolations.stream().collect(Collectors.groupingBy(pv -> pv.getPolicy() + "-" + pv.getConstraint(), LinkedHashMap::new, Collectors.toList()));
        for (String key : policyViolationsMap.keySet()) {
            List violations = (List)policyViolationsMap.get(key);
            PolicyViolationsModel policyViolation = (PolicyViolationsModel)violations.get(0);
            this.addSeparator(10);
            this.addPolicy(policyViolation, 2);
            this.addConstraint(policyViolation, 2);
            this.addSummary(violations, 6);
        }
        this.addSeparator(10);
    }

    private void addPolicy(PolicyViolationsModel policyViolation, int horizontalSpan) {
        CLabel label = new CLabel(this.parent, 128);
        label.setImage(policyViolation.getPolicyThreatLevel().getIcon());
        label.setText(policyViolation.getPolicy());
        label.setLayoutData((Object)new GridData(4, 4, true, true, horizontalSpan, 1));
        StylesUtils.updateBackgroundColor((Composite)label);
    }

    private void addConstraint(PolicyViolationsModel policyViolation, int horizontalSpan) {
        Label label = new Label(this.parent, 64);
        label.setText(policyViolation.getConstraint());
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true, horizontalSpan, 1));
        StylesUtils.updateBackgroundColor((Control)label);
    }

    private void addSummary(List<PolicyViolationsModel> violations, int horizontalSpan) {
        String violationList = this.getViolationsList(violations);
        Label label = new Label(this.parent, 64);
        label.setText(violationList);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true, horizontalSpan, 1));
        StylesUtils.updateBackgroundColor((Control)label);
    }

    private String getViolationsList(List<PolicyViolationsModel> violations) {
        return violations.stream().map(PolicyViolationsModel::getSummary).collect(Collectors.joining("\n"));
    }
}

