/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.details.tables;

import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ui.StylesUtils;
import com.sonatype.insight.ide.eclipse.internal.ui.component.ComponentInformationController;
import com.sonatype.insight.ide.eclipse.internal.ui.component.details.tables.BaseTable;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentDetailsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.SecurityIssuesModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;

public class SecurityIssuesTable
extends BaseTable {
    private List<Link> links = new ArrayList<Link>();

    public SecurityIssuesTable(Composite parent) {
        super(parent);
    }

    public void setSecurityIssues(ComponentDetailsModel componentDetails) {
        if (componentDetails.isUnknown()) {
            this.addMessage(Messages.SecurityIssuesTable_unknownComponentMessage);
            return;
        }
        if (componentDetails.isManual()) {
            this.addMessage(Messages.SecurityIssuesTable_claimedComponentMessage);
            return;
        }
        List<SecurityIssuesModel> securityIssues = componentDetails.getSecurityIssues();
        if (securityIssues == null || securityIssues.isEmpty()) {
            this.addMessage(Messages.SecurityIssuesTable_noLicenseAnalysisMessage);
            return;
        }
        this.createHeaders();
        this.addData(securityIssues);
    }

    private void createHeaders() {
        this.addSeparator(10);
        this.createHeader(Messages.SecurityIssuesTable_threatLevelColumn, 1);
        this.createHeader(Messages.SecurityIssuesTable_problemCodeColumn, 2);
        this.createHeader(Messages.SecurityIssuesTable_statusColumn, 1);
        this.createHeader(Messages.SecurityIssuesTable_summaryColumn, 6);
    }

    private void createHeader(String text, int horizontalSpan) {
        Label header = new Label(this.parent, 0);
        header.setText(text);
        header.setLayoutData((Object)new GridData(4, 128, true, true, horizontalSpan, 1));
        StylesUtils.updateBackgroundColor((Control)header);
        StylesUtils.makeBold((Control)header);
    }

    private void addData(List<SecurityIssuesModel> securityIssues) {
        for (SecurityIssuesModel securityIssue : securityIssues) {
            this.addSeparator(10);
            this.addThreatLevel(securityIssue);
            this.addProblemCode(securityIssue);
            this.addStatus(securityIssue);
            this.addSummary(securityIssue);
        }
        this.addSeparator(10);
    }

    private void addThreatLevel(SecurityIssuesModel securityIssue) {
        CLabel label = new CLabel(this.parent, 0);
        label.setImage(securityIssue.getSecurityThreatLevel().getIcon());
        label.setText(securityIssue.getSeverity());
        label.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        StylesUtils.updateBackgroundColor((Composite)label);
    }

    private void addProblemCode(SecurityIssuesModel securityIssue) {
        Link link = new Link(this.parent, 0);
        link.setText(String.format("<a>%s</a>", securityIssue.getProblemCode()));
        link.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.links.add(link);
        StylesUtils.updateBackgroundColor((Control)link);
    }

    private void addStatus(SecurityIssuesModel securityIssue) {
        Label label = new Label(this.parent, 0);
        label.setText(securityIssue.getStatus());
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        StylesUtils.updateBackgroundColor((Control)label);
    }

    private void addSummary(SecurityIssuesModel securityIssue) {
        Label label = new Label(this.parent, 64);
        label.setText(securityIssue.getSummary());
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 6, 1));
        StylesUtils.updateBackgroundColor((Control)label);
    }

    public void registerListeners(ComponentInformationController controller) {
        for (Link link : this.links) {
            link.addListener(13, event -> controller.handleProblemCodeLink(event.text));
        }
    }
}

