/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.model;

import com.sonatype.insight.ide.eclipse.Images;
import org.eclipse.swt.graphics.Image;

public enum BreakingChangesModel {
    SIGNIFICANT(4, "threat/threat-critical.png"),
    MODERATE(3, "threat/threat-severe.png"),
    MINOR(2, "threat/threat-moderate.png"),
    NONE(1, "threat/threat-none.png"),
    UNKNOWN(0, "threat/threat-unspecified.png");

    private final int value;
    private final Image icon;

    private BreakingChangesModel(int value, String iconFile) {
        this.value = value;
        this.icon = Images.getImage(iconFile);
    }

    public int getValue() {
        return this.value;
    }

    public Image getIcon() {
        return this.icon;
    }

    public static BreakingChangesModel getValue(Integer value) {
        if (value == null) {
            return NONE;
        }
        if (value > 5) {
            return SIGNIFICANT;
        }
        if (value >= 3) {
            return MODERATE;
        }
        if (value >= 1) {
            return MINOR;
        }
        if (value == 0) {
            return NONE;
        }
        return UNKNOWN;
    }
}

