/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.model;

import com.sonatype.clm.dto.model.SecurityVulnerability;
import com.sonatype.clm.dto.model.component.ComponentDetails;
import com.sonatype.clm.dto.model.component.NamedComponentDetails;
import com.sonatype.clm.dto.model.policy.ComponentFact;
import com.sonatype.clm.dto.model.policy.ConditionFact;
import com.sonatype.clm.dto.model.policy.ConstraintFact;
import com.sonatype.clm.dto.model.policy.PolicyAlert;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentDetailsMapper;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentDetailsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.LicenseAnalysisModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.PolicyViolationsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.SecurityIssuesModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ThreatLevelModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ComponentDetailsLoader {
    private final NamedComponentDetails namedComponentDetails;
    private ComponentDetailsModel componentDetailsModel = new ComponentDetailsModel(null);

    public ComponentDetailsLoader(NamedComponentDetails namedComponentDetails) {
        this.namedComponentDetails = namedComponentDetails;
        if (this.isComponentDetailsValid((ComponentDetails)namedComponentDetails)) {
            this.componentDetailsModel = this.newComponentDetails();
        }
    }

    private boolean isComponentDetailsValid(ComponentDetails componentDetails) {
        return componentDetails != null && componentDetails.getComponentIdentifier() != null;
    }

    public ComponentDetailsModel getComponentDetails() {
        return this.componentDetailsModel;
    }

    public ComponentDetailsModel getComponentDetailsCopy() {
        return this.newComponentDetails();
    }

    private ComponentDetailsModel newComponentDetails() {
        ComponentDetailsModel componentDetailsModel = this.loadComponentDetails();
        componentDetailsModel.setPolicyViolations(this.loadPolicyViolations());
        componentDetailsModel.setLicenseAnalysis(this.loadLicenseAnalysis());
        componentDetailsModel.setSecurityIssues(this.loadSecurityIssues());
        return componentDetailsModel;
    }

    private ComponentDetailsModel loadComponentDetails() {
        ComponentDetailsModel componentDetailsModel = new ComponentDetailsModel(this.namedComponentDetails.getComponentIdentifier());
        componentDetailsModel.setType(ComponentDetailsMapper.getType((ComponentDetails)this.namedComponentDetails)).setArtifact(ComponentDetailsMapper.getArtifact((ComponentDetails)this.namedComponentDetails)).setGroup(ComponentDetailsMapper.getGroup((ComponentDetails)this.namedComponentDetails)).setVersion(ComponentDetailsMapper.getVersion((ComponentDetails)this.namedComponentDetails)).isManual(ComponentDetailsMapper.isManual((ComponentDetails)this.namedComponentDetails)).setDeclaredLicense(ComponentDetailsMapper.getDeclaredLicenses((ComponentDetails)this.namedComponentDetails)).setObservedLicense(ComponentDetailsMapper.getObservedLicenses((ComponentDetails)this.namedComponentDetails)).setEffectiveLicense(ComponentDetailsMapper.getEffectiveLicenses((ComponentDetails)this.namedComponentDetails)).setHighestPolicyThreat(ComponentDetailsMapper.getHighestPolicyThreat((ComponentDetails)this.namedComponentDetails)).setPolicyCount(ComponentDetailsMapper.getPolicyCount((ComponentDetails)this.namedComponentDetails)).setHighestCvssScore(ComponentDetailsMapper.getHighestCvssScore((ComponentDetails)this.namedComponentDetails)).setSecurityIssuesCount(ComponentDetailsMapper.getSecurityIssuesCount((ComponentDetails)this.namedComponentDetails)).setIntegrityRating(this.namedComponentDetails.getIntegrityRating()).setHygieneRating(this.namedComponentDetails.getHygieneRating()).setCataloged(ComponentDetailsMapper.getCataloged((ComponentDetails)this.namedComponentDetails)).setMatchState(this.namedComponentDetails.getMatchState()).setIdentificationSource(this.namedComponentDetails.getIdentificationSource()).setCategory(ComponentDetailsMapper.getCategory((ComponentDetails)this.namedComponentDetails)).setWebsite(this.namedComponentDetails.getWebsite()).setIdentificationComment(this.namedComponentDetails.getIdentificationSourceComment()).isUnknown(ComponentDetailsMapper.isUnknown((ComponentDetails)this.namedComponentDetails));
        return componentDetailsModel;
    }

    public List<PolicyViolationsModel> loadPolicyViolations() {
        ArrayList<PolicyViolationsModel> policyViolations = new ArrayList<PolicyViolationsModel>();
        for (PolicyAlert alert : this.namedComponentDetails.getPolicyAlerts()) {
            for (ComponentFact fact : alert.getTrigger().getComponentFacts()) {
                for (ConstraintFact constraint : fact.getConstraintFacts()) {
                    for (ConditionFact condition : constraint.getConditionFacts()) {
                        int threatLevel = alert.getTrigger().getThreatLevel();
                        ThreatLevelModel policyThreatLevel = ThreatLevelModel.getValue(alert.getTrigger().getThreatLevel());
                        String policyName = alert.getTrigger().getPolicyName();
                        String constraintName = constraint.getConstraintName();
                        String summary = condition.getReason();
                        policyViolations.add(new PolicyViolationsModel(policyName, constraintName, summary, policyThreatLevel, threatLevel));
                    }
                }
            }
        }
        policyViolations.sort(Comparator.comparing(PolicyViolationsModel::getThreatLevel).reversed());
        return policyViolations;
    }

    public List<LicenseAnalysisModel> loadLicenseAnalysis() {
        ArrayList<LicenseAnalysisModel> licenAnalysis = new ArrayList<LicenseAnalysisModel>();
        int threatLevel = this.namedComponentDetails.getLicenseThreatLevel();
        ThreatLevelModel licenseThreatLevel = ThreatLevelModel.getValue(this.namedComponentDetails.getLicenseThreatLevel());
        String groupNames = ComponentDetailsMapper.getLicenseThreatGroupNames((ComponentDetails)this.namedComponentDetails);
        String overriddenLicenses = ComponentDetailsMapper.getOverriddenLicenses((ComponentDetails)this.namedComponentDetails);
        String declaredLicenses = ComponentDetailsMapper.getDeclaredLicenses((ComponentDetails)this.namedComponentDetails);
        String observedLicenses = ComponentDetailsMapper.getObservedLicenses((ComponentDetails)this.namedComponentDetails);
        licenAnalysis.add(new LicenseAnalysisModel(groupNames, overriddenLicenses, declaredLicenses, observedLicenses, licenseThreatLevel, threatLevel));
        return licenAnalysis;
    }

    public List<SecurityIssuesModel> loadSecurityIssues() {
        ArrayList<SecurityIssuesModel> securityIssues = new ArrayList<SecurityIssuesModel>();
        for (SecurityVulnerability vulnerability : this.namedComponentDetails.getSecurityVulnerabilities()) {
            Integer threatLevel = vulnerability.getSeverity() == null ? null : Integer.valueOf((int)Math.ceil(vulnerability.getSeverity().floatValue()));
            ThreatLevelModel securityThreatLevel = ThreatLevelModel.getValue(threatLevel);
            String severity = ComponentDetailsMapper.getIssueSeverity(vulnerability);
            String vulnerabilityName = ComponentDetailsMapper.getVulnerabilityName(vulnerability);
            String status = vulnerability.getStatus();
            String summary = vulnerability.getSummary();
            securityIssues.add(new SecurityIssuesModel(severity, vulnerabilityName, status, summary, securityThreatLevel, vulnerability.getSeverity()));
        }
        securityIssues.sort(Comparator.comparing(SecurityIssuesModel::getThreatLevel).reversed());
        return securityIssues;
    }
}

