/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.model;

import com.sonatype.clm.dto.model.License;
import com.sonatype.clm.dto.model.SecurityVulnerability;
import com.sonatype.clm.dto.model.component.ComponentDetails;
import com.sonatype.clm.dto.model.ide.LicenseStatus;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.TimeAgo;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.StringUtils;

public class ComponentDetailsMapper {
    public static final String UNKNOWN = "unknown";
    public static final String UNSCORED = "Unscored";
    public static final String NA = "NA";
    public static final String EMPTY_INDICATOR = "-";
    public static final String MANUAL_IDENTIFICATION_SOURCE = "Manual";

    public static String getType(ComponentDetails componentDetails) {
        return componentDetails.getComponentIdentifier().getFormat();
    }

    public static String getArtifact(ComponentDetails componentDetails) {
        return componentDetails.getComponentIdentifier().get("artifactId");
    }

    public static String getGroup(ComponentDetails componentDetails) {
        return componentDetails.getComponentIdentifier().get("groupId");
    }

    public static String getVersion(ComponentDetails componentDetails) {
        return componentDetails.getComponentIdentifier().get("version");
    }

    public static boolean isManual(ComponentDetails componentDetails) {
        return componentDetails.getIdentificationSource() != null && componentDetails.getIdentificationSource().equals(MANUAL_IDENTIFICATION_SOURCE);
    }

    public static String getLicenseThreatGroupNames(ComponentDetails componentDetails) {
        List licenseThreatGroupNames = componentDetails.getLicenseThreatGroupNames();
        if (licenseThreatGroupNames == null || licenseThreatGroupNames.isEmpty()) {
            return EMPTY_INDICATOR;
        }
        return componentDetails.getLicenseThreatGroupNames().stream().collect(Collectors.joining(","));
    }

    public static String getOverriddenLicenses(ComponentDetails componentDetails) {
        return ComponentDetailsMapper.getLicenses(componentDetails.getOverriddenLicenses());
    }

    public static String getDeclaredLicenses(ComponentDetails componentDetails) {
        return ComponentDetailsMapper.getLicenses(componentDetails.getDeclaredLicenses());
    }

    public static String getObservedLicenses(ComponentDetails componentDetails) {
        return ComponentDetailsMapper.getLicenses(componentDetails.getObservedLicenses());
    }

    public static String getEffectiveLicenses(ComponentDetails componentDetails) {
        LicenseStatus status = componentDetails.getEffectiveLicenseStatus();
        String licenses = ComponentDetailsMapper.getLicenses(componentDetails.getEffectiveLicenses());
        if (status != null) {
            return String.format("%s %s", licenses, status.name().toLowerCase());
        }
        return licenses;
    }

    public static String getHighestPolicyThreat(ComponentDetails componentDetails) {
        Integer highestPolicyThreat = ComponentDetailsMapper.getHighestPolicyThreatNumber(componentDetails);
        return highestPolicyThreat != -1 ? highestPolicyThreat.toString() : NA;
    }

    public static Integer getHighestPolicyThreatNumber(ComponentDetails componentDetails) {
        List policyAlerts = componentDetails.getPolicyAlerts();
        if (policyAlerts == null) {
            return -1;
        }
        return policyAlerts.stream().mapToInt(p -> p.getTrigger().getThreatLevel()).max().orElse(-1);
    }

    public static int getPolicyCount(ComponentDetails componentDetails) {
        List policyAlerts = componentDetails.getPolicyAlerts();
        return policyAlerts != null ? policyAlerts.size() : 0;
    }

    public static String getHighestCvssScore(ComponentDetails componentDetails) {
        List securityVulnerabilities = componentDetails.getSecurityVulnerabilities();
        if (securityVulnerabilities == null || securityVulnerabilities.size() == 0) {
            return NA;
        }
        return ComponentDetailsMapper.getIssueSeverity((SecurityVulnerability)securityVulnerabilities.get(0));
    }

    public static int getSecurityIssuesCount(ComponentDetails componentDetails) {
        List securityVulnerabilities = componentDetails.getSecurityVulnerabilities();
        return securityVulnerabilities != null ? securityVulnerabilities.size() : 0;
    }

    public static String getCataloged(ComponentDetails componentDetails) {
        Long catalogDate = componentDetails.getCatalogDate();
        if (catalogDate == null) {
            return EMPTY_INDICATOR;
        }
        return TimeAgo.toTimeAgo(catalogDate);
    }

    public static String getCategory(ComponentDetails componentDetails) {
        List categories = componentDetails.getComponentCategories();
        if (categories == null || categories.isEmpty()) {
            return EMPTY_INDICATOR;
        }
        return categories.stream().map(category -> category.getPath()).collect(Collectors.joining(","));
    }

    public static boolean isUnknown(ComponentDetails componentDetails) {
        return UNKNOWN.equals(componentDetails.getMatchState());
    }

    public static String getIssueSeverity(SecurityVulnerability vulnerability) {
        return vulnerability.getSeverity() == null ? UNSCORED : vulnerability.getSeverity().toString();
    }

    public static String getVulnerabilityName(SecurityVulnerability vulnerability) {
        if (vulnerability == null || StringUtils.isEmpty((String)vulnerability.getRefId()) || StringUtils.isEmpty((String)vulnerability.getSource())) {
            return EMPTY_INDICATOR;
        }
        String refId = vulnerability.getRefId().toUpperCase();
        if (refId.indexOf(vulnerability.getSource().toUpperCase()) == 0) {
            return refId;
        }
        return String.format("%s-%s", vulnerability.getSource().toUpperCase(), refId);
    }

    private static String getLicenses(Set<License> licenses) {
        if (licenses == null || licenses.isEmpty()) {
            return EMPTY_INDICATOR;
        }
        return licenses.stream().map(license -> license.getLicenseName()).collect(Collectors.joining(","));
    }
}

