/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.model;

import com.sonatype.clm.dto.model.component.ComponentDetails;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.ide.ComponentVersionInfo;
import com.sonatype.clm.dto.model.remediation.RemediationChangeOption;
import com.sonatype.clm.dto.model.remediation.RemediationRecommendedChangeOption;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.BreakingChangesModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentDetailsMapper;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentVersionDetailsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.RemediationOptionModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.RemediationTypeModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ThreatLevelModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ComponentVersionDetailsLoader {
    private final ComponentVersionInfo allVersionsInfo;
    private final ComponentIdentifier identifier;
    private List<ComponentVersionDetailsModel> componentVersions = new ArrayList<ComponentVersionDetailsModel>();
    private Map<String, List<RemediationOptionModel>> remediationOptions = new HashMap<String, List<RemediationOptionModel>>();
    private RemediationOptionModel recommendedRemediationOption;

    public ComponentVersionDetailsLoader(ComponentVersionInfo allVersionsInfo, ComponentIdentifier identifier) {
        this.allVersionsInfo = allVersionsInfo;
        this.identifier = identifier;
        if (this.areVersionsValid(allVersionsInfo)) {
            this.recommendedRemediationOption = this.loadSuggestedRemediation();
            this.remediationOptions = this.loadRemediationOptions();
            this.componentVersions = this.loadComponentVersionDetails();
        }
    }

    private boolean areVersionsValid(ComponentVersionInfo allVersionsInfo) {
        return allVersionsInfo != null && allVersionsInfo.getAllVersions() != null && !allVersionsInfo.getAllVersions().isEmpty();
    }

    public List<ComponentVersionDetailsModel> getComponentVersions() {
        return this.componentVersions;
    }

    public List<RemediationOptionModel> getRemediationOptions() {
        return this.remediationOptions.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList());
    }

    public ComponentVersionDetailsModel getComponentVersionInUse() {
        return this.getComponentVersions().stream().filter(data -> data.isInUse()).findFirst().get();
    }

    public ComponentVersionDetailsModel getComponentByVersion(String version) {
        return this.getComponentVersions().stream().filter(data -> data.getVersion().equals(version)).findFirst().get();
    }

    public RemediationOptionModel getRecommendedOption() {
        return this.recommendedRemediationOption;
    }

    private Map<String, List<RemediationOptionModel>> loadRemediationOptions() {
        HashMap<String, List<RemediationOptionModel>> remediationOptions = new HashMap<String, List<RemediationOptionModel>>();
        for (RemediationChangeOption option : this.allVersionsInfo.getRemediation().getVersionChanges()) {
            String remediationVersion = option.getData().getComponent().getComponentIdentifier().get("version");
            boolean isRemediationVersionInUse = remediationVersion.equals(this.identifier.get("version"));
            RemediationTypeModel remediation = RemediationTypeModel.get(option.getType());
            RemediationOptionModel remediationOption = new RemediationOptionModel(remediationVersion, remediation, isRemediationVersionInUse, false);
            List remediationsForVersion = remediationOptions.getOrDefault(remediationVersion, new ArrayList());
            remediationsForVersion.add(remediationOption);
            if (remediationsForVersion.size() != 1) continue;
            remediationOptions.put(remediationVersion, remediationsForVersion);
        }
        if (this.recommendedRemediationOption != null) {
            remediationOptions.values().forEach(list -> {
                boolean bl = list.removeIf(remediationOption -> remediationOption.getRemediationType().equals((Object)this.recommendedRemediationOption.getRemediationType()));
            });
        }
        return remediationOptions;
    }

    public RemediationOptionModel loadSuggestedRemediation() {
        RemediationRecommendedChangeOption suggestedVersionChange = this.allVersionsInfo.getRemediation().getSuggestedVersionChange();
        if (suggestedVersionChange == null) {
            return null;
        }
        String suggestedVersion = suggestedVersionChange.getData().getComponent().getComponentIdentifier().get("version");
        boolean isSuggestedVersionInUse = suggestedVersion.equals(this.identifier.get("version"));
        RemediationTypeModel suggestedRemediation = RemediationTypeModel.get(suggestedVersionChange.getType());
        RemediationOptionModel suggestedRemediationOption = new RemediationOptionModel(suggestedVersion, suggestedRemediation, isSuggestedVersionInUse, suggestedVersionChange.getIsGolden());
        return suggestedRemediationOption;
    }

    private List<ComponentVersionDetailsModel> loadComponentVersionDetails() {
        ArrayList<ComponentVersionDetailsModel> versionDetailsList = new ArrayList<ComponentVersionDetailsModel>();
        for (ComponentDetails componentDetails : this.allVersionsInfo.getAllVersions()) {
            List<RemediationOptionModel> options;
            if (componentDetails == null) continue;
            ComponentVersionDetailsModel details = this.createComponentVersionDetail(componentDetails);
            String versionInUse = this.identifier.get("version");
            if (details.getVersion().equals(versionInUse)) {
                details.setInUse(true);
            }
            if ((options = this.remediationOptions.get(details.getVersion())) != null) {
                List<RemediationTypeModel> remediationTypes = options.stream().map(option -> option.getRemediationType()).collect(Collectors.toList());
                if (!details.getVersion().equals(versionInUse)) {
                    details.setRemediationTypes(remediationTypes);
                }
            }
            versionDetailsList.add(details);
        }
        return versionDetailsList;
    }

    private ComponentVersionDetailsModel createComponentVersionDetail(ComponentDetails componentDetails) {
        String version = ComponentDetailsMapper.getVersion(componentDetails);
        ThreatLevelModel threatLevel = this.getThreatLevel(componentDetails);
        BreakingChangesModel breakingChanges = this.getBreakingChanges(componentDetails);
        Integer popularity = componentDetails.getRelativePopularity();
        return new ComponentVersionDetailsModel(version, threatLevel, breakingChanges, popularity);
    }

    private BreakingChangesModel getBreakingChanges(ComponentDetails componentDetails) {
        return BreakingChangesModel.getValue(componentDetails.getBreakingChangesCount());
    }

    private ThreatLevelModel getThreatLevel(ComponentDetails componentDetails) {
        Integer threatLevel = ComponentDetailsMapper.getHighestPolicyThreatNumber(componentDetails);
        return ThreatLevelModel.getValue(threatLevel);
    }
}

