/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.model;

import com.sonatype.insight.ide.eclipse.Images;
import org.eclipse.swt.graphics.Image;

public enum ThreatLevelModel {
    CRITICAL(0, "threat/threat-critical.png"),
    SEVERE(1, "threat/threat-severe.png"),
    MODERATE(2, "threat/threat-moderate.png"),
    LOW(3, "threat/threat-low.png"),
    NONE(4, "threat/threat-none.png"),
    UNSPECIFIED(5, "threat/threat-unspecified.png");

    private final int value;
    private final Image icon;

    private ThreatLevelModel(int value, String iconFile) {
        this.value = value;
        this.icon = Images.getImage(iconFile);
    }

    public int getValue() {
        return this.value;
    }

    public Image getIcon() {
        return this.icon;
    }

    public String getText() {
        return "threatLevel." + this.name();
    }

    public static ThreatLevelModel getValue(Integer value) {
        if (value == null) {
            return UNSPECIFIED;
        }
        if (value > 7) {
            return CRITICAL;
        }
        if (value > 3) {
            return SEVERE;
        }
        if (value > 1) {
            return MODERATE;
        }
        if (value == 1) {
            return LOW;
        }
        return NONE;
    }
}

