/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.model;

import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeAgo {
    private static final String LESS_THAN_A_DAY_AGO = "Less than a day ago";
    private static final String AGO = "ago";
    private static final String DAY = "day";
    private static final String MONTH = "month";
    private static final String YEAR = "year";
    private static final String DAYS = "days";
    private static final String MONTHS = "months";
    private static final String YEARS = "years";

    public static String toTimeAgo(Long pastDate) {
        Long elapsedTime = new Date().getTime() - pastDate;
        Long value = 0L;
        String unit = "";
        Long yearInMillis = TimeUnit.DAYS.toMillis(365L);
        Long monthInMillis = TimeUnit.DAYS.toMillis(30L);
        Long dayInMillis = TimeUnit.DAYS.toMillis(1L);
        if (elapsedTime >= yearInMillis) {
            value = elapsedTime / yearInMillis;
            unit = value > 1L ? YEARS : YEAR;
        } else if (elapsedTime >= monthInMillis) {
            value = elapsedTime / monthInMillis;
            unit = value > 1L ? MONTHS : MONTH;
        } else if (elapsedTime >= dayInMillis) {
            value = elapsedTime / dayInMillis;
            unit = value > 1L ? DAYS : DAY;
        } else {
            return LESS_THAN_A_DAY_AGO;
        }
        return String.format("%s %s %s", value, unit, AGO);
    }
}

