/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.versions;

import com.sonatype.insight.ide.eclipse.Images;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ui.StylesUtils;
import com.sonatype.insight.ide.eclipse.internal.ui.component.BaseComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.ComponentInformationController;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentVersionDetailsLoader;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentVersionDetailsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.RemediationOptionModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.versions.remediation.RemediationsComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.versions.table.VersionHistoryTableViewer;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class VersionHistoryComposite
extends BaseComposite {
    private static final int SEPARATOR_HEIGHT = 10;
    private CLabel recommendationsHeader;
    private RemediationsComposite remediationsComposite;
    private VersionHistoryTableViewer versionHistoryTable;

    public VersionHistoryComposite(Composite parent, int style) {
        super(parent, style);
        this.createRemediatonsPanel();
        this.createEmptySeparator();
        this.createVersionHistoryTable();
    }

    private void createRemediatonsPanel() {
        this.recommendationsHeader = this.createHeader(Messages.RemediationsComposite_availableFixVersions);
        this.remediationsComposite = new RemediationsComposite(this, 0);
        this.remediationsComposite.setLayoutData(new GridData(4, 128, true, false, 1, 1));
    }

    private void createVersionHistoryTable() {
        this.createHeader(Messages.RemediationsComposite_versionHistory);
        this.versionHistoryTable = new VersionHistoryTableViewer(this, 66048);
        this.versionHistoryTable.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    private CLabel createHeader(String text) {
        CLabel header = new CLabel((Composite)this, 0);
        header.setLayoutData((Object)new GridData(16384, 128, true, false, 1, 1));
        header.setText(text);
        StylesUtils.makeBold((Control)header);
        return header;
    }

    private void createEmptySeparator() {
        Label header = new Label((Composite)this, 0);
        GridData gl_data = new GridData(16384, 128, false, false, 1, 1);
        gl_data.heightHint = 10;
        header.setLayoutData((Object)gl_data);
    }

    public void loadRemediations(ComponentVersionDetailsLoader dataProvider) {
        this.checkWidget();
        RemediationOptionModel recommendedOption = dataProvider.getRecommendedOption();
        if (recommendedOption != null) {
            if (recommendedOption.isGolden()) {
                this.recommendationsHeader.setText(Messages.RemediationsComposite_goldenVersion);
                this.recommendationsHeader.setImage(Images.getImage("star.png"));
                this.recommendationsHeader.setLeftMargin(0);
            } else {
                this.recommendationsHeader.setText(Messages.RemediationsComposite_recommendedVersion);
                this.recommendationsHeader.setImage(null);
                this.recommendationsHeader.setLeftMargin(3);
            }
            this.remediationsComposite.setSuggestedRemediation(recommendedOption);
        } else {
            this.recommendationsHeader.setText(Messages.RemediationsComposite_availableFixVersions);
            this.recommendationsHeader.setImage(null);
            this.recommendationsHeader.setLeftMargin(3);
            List<RemediationOptionModel> remediationOptions = dataProvider.getRemediationOptions();
            this.remediationsComposite.setRemediations(remediationOptions);
        }
        this.layout();
    }

    public void loadComponentVersions(ComponentVersionDetailsLoader dataProvider) {
        this.checkWidget();
        this.versionHistoryTable.setInput(dataProvider);
        this.setSelectVersion(dataProvider.getComponentVersionInUse());
        this.layout();
    }

    public void setSelectVersion(ComponentVersionDetailsModel componentVersion) {
        this.checkWidget();
        this.versionHistoryTable.setSelectVersion(componentVersion);
    }

    public void registerListeners(ComponentInformationController controller) {
        this.checkWidget();
        this.remediationsComposite.registerListeners(controller);
        this.versionHistoryTable.registerListeners(controller);
    }
}

