/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.versions.remediation;

import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.rest.InsightClientManager;
import com.sonatype.insight.ide.eclipse.internal.rest.UserInteraction;
import com.sonatype.insight.ide.eclipse.internal.ui.component.BaseComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.component.ComponentInformationController;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.RemediationOptionModel;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;

public class RemediationsComposite
extends BaseComposite {
    private static final Pattern VERSION_PATTERN = Pattern.compile("Select (.+)", 2);
    private Link link;

    public RemediationsComposite(Composite parent, int style) {
        super(parent, style);
        this.createRemediationMessage();
    }

    private void createRemediationMessage() {
        this.link = new Link((Composite)this, 64);
        this.link.setLayoutData((Object)new GridData(16384, 128, true, false, 1, 1));
    }

    public void setRemediations(List<RemediationOptionModel> options) {
        this.checkWidget();
        if (options.isEmpty()) {
            this.addNoRemediationsMessage();
            return;
        }
        this.addRemediationsMessages(options);
    }

    private void addNoRemediationsMessage() {
        this.link.setText(Messages.RemediationsComposite_noRemediationsMessage);
    }

    private void addRemediationsMessages(List<RemediationOptionModel> options) {
        StringBuilder text = new StringBuilder();
        for (RemediationOptionModel option : options) {
            if (option.isRecommendedVersionInUse()) {
                text.append(option.getRemediationTypeText());
            } else {
                text.append(String.format("- <a>Select %s</a>  %s", option.getRecommendedVersion(), option.getRemediationTypeText()));
            }
            text.append("\n");
        }
        this.link.setText(text.toString());
    }

    private void addRemediationsMessage(RemediationOptionModel option) {
        StringBuilder text = new StringBuilder();
        if (option.isRecommendedVersionInUse()) {
            text.append(option.getRemediationTypeText());
        } else {
            text.append(String.format("- <a>Select %s</a>  %s", option.getRecommendedVersion(), option.getRemediationTypeText()));
        }
        this.link.setText(text.toString());
    }

    public void registerListeners(ComponentInformationController controller) {
        this.checkWidget();
        this.link.addListener(13, event -> {
            Matcher matcher = VERSION_PATTERN.matcher(event.text);
            if (matcher.find()) {
                InsightClientManager.getInstance().getUserInteractionCountMap().get((Object)UserInteraction.RECOMMENDED_LINK_CLICKED).incrementAndGet();
                String version = matcher.group(1);
                controller.selectVersionOnTable(version);
            }
        });
    }

    public void setSuggestedRemediation(RemediationOptionModel suggestedRemediation) {
        this.checkWidget();
        this.addRemediationsMessage(suggestedRemediation);
    }
}

