/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.versions.table;

import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentVersionDetailsModel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class VersionHistoryTableComparator
extends ViewerComparator {
    private static final Comparator<ComponentVersionDetailsModel> VERSION_COMPARATOR = Comparator.comparing(x -> new DefaultArtifactVersion(x.getVersion())).thenComparing(x -> x.getThreatLevel().getValue()).thenComparing(x -> x.getBreakingChanges().getValue()).thenComparing(x -> x.getPopularity());
    private static final Comparator<ComponentVersionDetailsModel> THREAT_LEVEL_COMPARATOR = Comparator.comparing(x -> x.getThreatLevel().getValue()).thenComparing(x -> new DefaultArtifactVersion(x.getVersion())).thenComparing(x -> x.getBreakingChanges().getValue()).thenComparing(x -> x.getPopularity());
    private static final Comparator<ComponentVersionDetailsModel> BREAKING_CHANGES_COMPARATOR = Comparator.comparing(x -> x.getBreakingChanges().getValue()).thenComparing(x -> new DefaultArtifactVersion(x.getVersion())).thenComparing(x -> x.getThreatLevel().getValue()).thenComparing(x -> x.getPopularity());
    private static final Comparator<ComponentVersionDetailsModel> POPULARITY_COMPARATOR = Comparator.comparing(x -> x.getPopularity()).thenComparing(x -> new DefaultArtifactVersion(x.getVersion())).thenComparing(x -> x.getThreatLevel().getValue()).thenComparing(x -> x.getBreakingChanges().getValue());
    private static final List<Comparator<ComponentVersionDetailsModel>> COMPARATORS = Arrays.asList(VERSION_COMPARATOR, THREAT_LEVEL_COMPARATOR, BREAKING_CHANGES_COMPARATOR, POPULARITY_COMPARATOR);
    private Comparator<ComponentVersionDetailsModel> comparator = VERSION_COMPARATOR;
    private int column = 0;
    private boolean ascending = true;

    public void setSort(int column, boolean ascending) {
        this.column = column;
        this.ascending = ascending;
        this.comparator = this.ascending ? COMPARATORS.get(this.column) : COMPARATORS.get(column).reversed();
    }

    public int getColumn() {
        return this.column;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isSorterProperty(Object element, String property) {
        return true;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof ComponentVersionDetailsModel && e2 instanceof ComponentVersionDetailsModel) {
            return this.comparator.compare((ComponentVersionDetailsModel)e1, (ComponentVersionDetailsModel)e2);
        }
        return super.compare(viewer, e1, e2);
    }
}

