/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.versions.table;

import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ui.DelegatingStyledCellLabelProviderWithTooltips;
import com.sonatype.insight.ide.eclipse.internal.ui.component.ComponentInformationController;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentVersionDetailsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.versions.table.VersionHistoryTableComparator;
import com.sonatype.insight.ide.eclipse.internal.ui.component.versions.table.VersionHistoryTableSelectionAdapter;
import com.sonatype.insight.ide.eclipse.internal.ui.component.versions.table.provider.BreakingChangesLabelProvider;
import com.sonatype.insight.ide.eclipse.internal.ui.component.versions.table.provider.PopularityLabelProvider;
import com.sonatype.insight.ide.eclipse.internal.ui.component.versions.table.provider.ThreatLevelLabelProvider;
import com.sonatype.insight.ide.eclipse.internal.ui.component.versions.table.provider.VersionHistoryProvider;
import com.sonatype.insight.ide.eclipse.internal.ui.component.versions.table.provider.VersionLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class VersionHistoryTableViewer
extends TableViewer {
    private static final String[] HEADERS = new String[]{Messages.VersionHistoryTableViewer_versionColumn, Messages.VersionHistoryTableViewer_threatLevelColumn, Messages.VersionHistoryTableViewer_breakingChangesColumn, Messages.VersionHistoryTableViewer_popularityColumn};
    static final int VERSION_COLUMN = 0;
    static final int THREAT_COLUMN = 1;
    static final int BREAKING_CHANGES_COLUMN = 2;
    static final int POPULARITY_COLUMN = 3;
    private List<TableViewerColumn> columns = new ArrayList<TableViewerColumn>();
    private final VersionHistoryTableComparator comparator = new VersionHistoryTableComparator();

    public VersionHistoryTableViewer(Composite parent, int style) {
        super(parent, style);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this);
        this.getTable().setHeaderVisible(true);
        this.getTable().setLinesVisible(true);
        this.configureDefaultOrder();
        this.createColumns();
        this.addControlListener();
    }

    private void configureDefaultOrder() {
        this.comparator.setSort(0, true);
        this.setComparator(this.comparator);
        this.setContentProvider((IContentProvider)new VersionHistoryProvider());
    }

    private void createColumns() {
        this.columns.add(this.createTableViewerColumn(0, new DelegatingStyledCellLabelProviderWithTooltips(new VersionLabelProvider())));
        this.columns.add(this.createTableViewerColumn(1, new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ThreatLevelLabelProvider())));
        this.columns.add(this.createTableViewerColumn(2, new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new BreakingChangesLabelProvider())));
        this.columns.add(this.createTableViewerColumn(3, new PopularityLabelProvider()));
    }

    private <T extends CellLabelProvider> TableViewerColumn createTableViewerColumn(int index, T provider) {
        TableViewerColumn column = new TableViewerColumn((TableViewer)this, 16384, index);
        column.getColumn().addSelectionListener((SelectionListener)new VersionHistoryTableSelectionAdapter(index, this.comparator, this));
        column.getColumn().setText(HEADERS[index]);
        column.setLabelProvider(provider);
        return column;
    }

    private void addControlListener() {
        Table table = this.getTable();
        table.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent unused) {
                VersionHistoryTableViewer.this.updateTableLayout();
            }

            public void controlMoved(ControlEvent unused) {
            }
        });
    }

    private void updateTableLayout() {
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        this.getTable().setLayout((Layout)tableLayout);
    }

    public void setSelectVersion(ComponentVersionDetailsModel componentVersion) {
        StructuredSelection structuredSelection = new StructuredSelection((Object)componentVersion);
        this.setSelection((ISelection)structuredSelection, true);
    }

    public void registerListeners(final ComponentInformationController controller) {
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = VersionHistoryTableViewer.this.getStructuredSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof ComponentVersionDetailsModel) {
                    ComponentVersionDetailsModel data = (ComponentVersionDetailsModel)firstElement;
                    controller.loadDetailsForVersion(data);
                }
            }
        });
    }
}

