/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.component.versions.table.provider;

import com.sonatype.insight.ide.eclipse.Images;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.ComponentVersionDetailsModel;
import com.sonatype.insight.ide.eclipse.internal.ui.component.model.RemediationTypeModel;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class VersionLabelProvider
extends ColumnLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public String getText(Object element) {
        if (element instanceof ComponentVersionDetailsModel) {
            return "";
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof ComponentVersionDetailsModel) {
            return Images.getImage("obj16/jar_obj.gif");
        }
        return super.getImage(element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof ComponentVersionDetailsModel) {
            ComponentVersionDetailsModel data = (ComponentVersionDetailsModel)element;
            if (data.isInUse() && data.getRemediationTypes() != null) {
                return this.getRemediationTypesText(data.getRemediationTypes(), true);
            }
            if (data.isInUse()) {
                return "currently in use";
            }
            if (data.getRemediationTypes() != null) {
                return this.getRemediationTypesText(data.getRemediationTypes(), false);
            }
            return null;
        }
        return super.getToolTipText(element);
    }

    private String getRemediationTypesText(List<RemediationTypeModel> types, boolean inUse) {
        StringBuilder remediationText = new StringBuilder();
        for (RemediationTypeModel remediationType : types) {
            remediationText.append(remediationType.getText(inUse));
            remediationText.append("\n");
        }
        return remediationText.toString().trim();
    }

    public StyledString getStyledText(Object element) {
        StyledString ss = new StyledString();
        if (element instanceof ComponentVersionDetailsModel) {
            ComponentVersionDetailsModel data = (ComponentVersionDetailsModel)element;
            ss.append(data.getVersion());
            if (data.isInUse()) {
                ss.append(" - in-use", StyledString.DECORATIONS_STYLER);
                return ss;
            }
            if (data.getRemediationTypes() != null) {
                ss.append(" - suggested", StyledString.DECORATIONS_STYLER);
                return ss;
            }
        }
        return ss;
    }
}

