/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.edit;

import com.sonatype.insight.ide.eclipse.internal.ArtifactKey;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.edit.CollectVersionPropertiesOperation;
import com.sonatype.insight.ide.eclipse.internal.edit.FindDependencyOperation;
import com.sonatype.insight.ide.eclipse.internal.edit.RandomUtils;
import com.sonatype.insight.ide.eclipse.internal.edit.UpdateDependencyOperation;
import com.sonatype.insight.ide.eclipse.internal.helpers.MavenHelper;
import com.sonatype.insight.ide.eclipse.internal.rest.InsightClientManager;
import com.sonatype.insight.ide.eclipse.internal.rest.RestClient;
import com.sonatype.insight.ide.eclipse.internal.rest.UrlBuilder;
import com.sonatype.insight.ide.eclipse.internal.ui.DependencyContentProvider;
import com.sonatype.insight.ide.eclipse.internal.ui.edit.DependencyUpdateRefContext;
import com.sonatype.insight.ide.eclipse.internal.ui.edit.MavenProjectHierarchy;
import com.sonatype.insight.ide.eclipse.internal.ui.edit.MultiPropertyRefContext;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class DependencyUpdateRefactoring
extends Refactoring {
    private final Iterable<UIDependencyElement> list;
    private Map<IFile, List<? extends PomEdits.Operation>> mavenUpdates;
    private final Collection<IProject> allProjects;
    private Collection<MultiPropertyRefContext> propertyContexts = new ArrayList<MultiPropertyRefContext>();
    private Set<OneProject> oneProjects;
    private List<UIDependencyElement> additionalUpdateVersionsToClear = new ArrayList<UIDependencyElement>();
    private Map<UIDependencyElement, Boolean> versionAvailable = new HashMap<UIDependencyElement, Boolean>();
    private DependencyContentProvider provider;

    public DependencyUpdateRefactoring(Collection<IProject> allProjects, UIDependencyElement changingElement, DependencyContentProvider provider) {
        this.list = Collections.singleton(changingElement);
        this.allProjects = allProjects;
        this.provider = provider;
    }

    public String getName() {
        return Messages.DependencyUpdateRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RestClient client = InsightClientManager.getInstance().getClient();
        RefactoringStatus status = new RefactoringStatus();
        HashMap prjToDep = new HashMap();
        HashMap err1prjToDep = new HashMap();
        for (UIDependencyElement uIDependencyElement : this.list) {
            if (uIDependencyElement.getUpdateVersion() == null) continue;
            this.versionAvailable.put(uIDependencyElement, Boolean.TRUE);
            for (IProject prj : uIDependencyElement.getProjects()) {
                if (!prj.isOpen()) {
                    status.addError(NLS.bind((String)Messages.DependencyUpdateRefactoring_closedProject, (Object)prj.getName()));
                    continue;
                }
                if (!prj.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                    RandomUtils.addToMap(err1prjToDep, prj, uIDependencyElement);
                    continue;
                }
                RandomUtils.addToMap(prjToDep, prj, uIDependencyElement);
            }
        }
        for (Map.Entry entry : err1prjToDep.entrySet()) {
            DependencyUpdateRefContext cont = new DependencyUpdateRefContext(DependencyUpdateRefContext.Type.NO_MAVEN_PROJECT);
            cont.setProjects(Collections.singletonList((IProject)entry.getKey()));
            cont.setDependencyElements((Collection)entry.getValue());
            cont.setInformation(Messages.DependencyUpdateRefactoring_warningNonMavenProjectInfo);
            status.addWarning(NLS.bind((String)Messages.DependencyUpdateRefactoring_warningNonMavenProject, (Object)((IProject)entry.getKey()).getName()), (RefactoringStatusContext)cont);
        }
        for (IProject iProject : this.allProjects) {
            List res;
            if (!iProject.isOpen() || !iProject.hasNature("org.eclipse.m2e.core.maven2Nature") || (res = (List)prjToDep.get(iProject)) != null) continue;
            prjToDep.put(iProject, new ArrayList());
        }
        this.oneProjects = this.constructProjectHierarchies(prjToDep.entrySet(), pm);
        LinkedList<OneProject> linkedList = new LinkedList<OneProject>();
        linkedList.addAll(this.oneProjects);
        while (!linkedList.isEmpty()) {
            OneProject one;
            OneProject oneProject = one = linkedList.isEmpty() ? null : (OneProject)linkedList.removeFirst();
            if (!one.isChildrenProcessed()) {
                linkedList.addLast(one);
                continue;
            }
            if (one.isProcessed()) continue;
            try {
                this.collectInformationOnProject(status, one);
                ArrayList<FindDependencyOperation> copy = new ArrayList<FindDependencyOperation>(one.getUnresolvedOperations());
                for (FindDependencyOperation op : copy) {
                    if (!op.isFound()) continue;
                    UpdateDependencyOperation update = new UpdateDependencyOperation(op.getElement());
                    update.setManaged(op.isManaged());
                    update.setProfile(op.getProfile());
                    update.setRawArtifactId(op.getRawArtifactId());
                    update.setRawGroupId(op.getRawGroupId());
                    update.setNewVersionValue(op.getNewVersion());
                    update.setPropertyName(op.getPropertyName());
                    update.setPropertyProfile(op.getPropertyProfile());
                    if (op.getPropertyName() != null) {
                        update.setPropertyCandidate(true);
                        one.addPropertyCandidate(update);
                        continue;
                    }
                    one.resolve(update, op.getElement());
                }
                HashMap propUpdates = new HashMap();
                List<UpdateDependencyOperation> childPropCandidates = one.getRecursivePropertyWritingCandidates();
                Set<String> definedProps = one.getDefinedPropertiesMap().keySet();
                Iterator<Object> iterator = childPropCandidates.iterator();
                while (iterator.hasNext()) {
                    UpdateDependencyOperation updateDependencyOperation = (UpdateDependencyOperation)iterator.next();
                    String propName = updateDependencyOperation.getPropertyName();
                    if (!definedProps.contains(propName)) continue;
                    RandomUtils.addToMap(propUpdates, propName, updateDependencyOperation);
                }
                for (Map.Entry entry : propUpdates.entrySet()) {
                    OneProject source;
                    Set<String> deps = one.getDepsUsingVersionProperty((String)entry.getKey(), true);
                    String versionValue = null;
                    HashSet<UIDependencyElement> changingEls = new HashSet<UIDependencyElement>();
                    HashSet<IProject> changingprjs = new HashSet<IProject>();
                    boolean multiVersionValue = false;
                    for (UpdateDependencyOperation oper : (List)entry.getValue()) {
                        Iterator<String> it = deps.iterator();
                        changingEls.add(oper.getFindAssociate());
                        changingprjs.addAll(oper.getFindAssociate().getProjects());
                        while (it.hasNext()) {
                            String d = it.next();
                            if (!d.equals(oper.getRawGroupId() + ":" + oper.getRawArtifactId())) continue;
                            if (versionValue == null) {
                                versionValue = oper.getNewVersionValue();
                            } else if (!versionValue.equals(oper.getNewVersionValue())) {
                                multiVersionValue = true;
                            }
                            it.remove();
                            break;
                        }
                        this.versionAvailable.put(oper.getFindAssociate(), DependencyUpdateRefactoring.hasVersion(client, oper.getFindAssociate(), oper.getNewVersionValue()));
                    }
                    if (multiVersionValue) {
                        status.addWarning(NLS.bind((String)Messages.DependencyUpdateRefactoring_warningPropertyUpdate, entry.getKey()));
                        for (UpdateDependencyOperation oper : (List)entry.getValue()) {
                            source = one.findOneWithPropertyCandidate(oper);
                            oper.setWriteAsProperty(false);
                            oper.setPropertyCandidate(false);
                            source.resolve(oper, oper.getFindAssociate());
                            source.removePropertyCandidate(oper);
                        }
                        continue;
                    }
                    if (deps.size() > 0) {
                        MultiPropertyRefContext cont = new MultiPropertyRefContext();
                        cont.setProjects(changingprjs);
                        cont.setDependenciesUsingProperty(deps);
                        cont.setProperty((String)entry.getKey());
                        StringBuffer list = new StringBuffer();
                        for (String dep : deps) {
                            list.append(dep).append('\n');
                        }
                        cont.setDependencyElements(changingEls);
                        cont.setInformation(NLS.bind((String)Messages.DependencyUpdateRefactoring_warningPropertyNonUpdatedInfo, (Object[])new Object[]{entry.getKey(), one.getProject().getName(), list.toString()}));
                        for (UpdateDependencyOperation oper : (List)entry.getValue()) {
                            OneProject source2 = one.findOneWithPropertyCandidate(oper);
                            oper.setWriteAsProperty(false);
                            oper.setPropertyCandidate(false);
                            source2.resolve(null, oper.getFindAssociate());
                            source2.removePropertyCandidate(oper);
                            cont.addNonPropUpdate(source2, oper);
                        }
                        UpdateDependencyOperation update = new UpdateDependencyOperation(null);
                        update.setNewVersionValue(versionValue);
                        update.setPropertyName((String)entry.getKey());
                        List<String> profiles = one.getDefinedPropertiesMap().get(entry.getKey());
                        if (!profiles.contains(null) && profiles.size() > 0) {
                            update.setPropertyProfile(profiles.get(0));
                        }
                        update.setWriteAsProperty(true);
                        update.setPropertyCandidate(false);
                        cont.setPropUpdate(one, update);
                        this.propertyContexts.add(cont);
                        continue;
                    }
                    for (UpdateDependencyOperation oper : (List)entry.getValue()) {
                        source = one.findOneWithPropertyCandidate(oper);
                        oper.setWriteAsProperty(false);
                        oper.setPropertyCandidate(false);
                        source.resolve(null, oper.getFindAssociate());
                        source.removePropertyCandidate(oper);
                        this.additionalUpdateVersionsToClear.add(oper.getFindAssociate());
                    }
                    UpdateDependencyOperation update = new UpdateDependencyOperation(null);
                    update.setNewVersionValue(versionValue);
                    update.setPropertyName((String)entry.getKey());
                    List<String> profiles = one.getDefinedPropertiesMap().get(entry.getKey());
                    if (!profiles.contains(null) && profiles.size() > 0) {
                        update.setPropertyProfile(profiles.get(0));
                    }
                    update.setWriteAsProperty(true);
                    update.setPropertyCandidate(false);
                    one.resolve(update, null);
                }
            }
            finally {
                one.setProcessed(true);
            }
        }
        for (OneProject one : this.oneProjects) {
            for (UpdateDependencyOperation oper : one.getPropertyWritingCandidates()) {
                status.addWarning(NLS.bind((String)Messages.DependencyUpdateRefactoring_warningPropertyNotFound, (Object)oper.getPropertyName(), (Object)one.getProject().getName()));
                oper.setWriteAsProperty(false);
                oper.setPropertyCandidate(false);
                one.resolve(oper, oper.getFindAssociate());
            }
        }
        for (OneProject one : this.oneProjects) {
            ArrayList<UIDependencyElement> trans = new ArrayList<UIDependencyElement>();
            ArrayList<UIDependencyElement> others = new ArrayList<UIDependencyElement>();
            for (UIDependencyElement unres : one.getUnresolvedUpdates()) {
                boolean transitive = MavenHelper.isTransitive(unres, one.getMavenProject());
                if (transitive) {
                    trans.add(unres);
                    continue;
                }
                others.add(unres);
            }
            if (trans.size() > 0) {
                Iterator it = trans.iterator();
                while (it.hasNext()) {
                    UIDependencyElement uIDependencyElement = (UIDependencyElement)it.next();
                    if (!this.comesViaWorkspaceProject(one.getMavenProject(), uIDependencyElement, this.oneProjects)) continue;
                    it.remove();
                }
                if (trans.size() > 0) {
                    DependencyUpdateRefContext dependencyUpdateRefContext = new DependencyUpdateRefContext(DependencyUpdateRefContext.Type.NOT_FOUND_TRANSITIVE);
                    dependencyUpdateRefContext.setProjects(Collections.singletonList(one.getProject()));
                    dependencyUpdateRefContext.setDependencyElements(trans);
                    dependencyUpdateRefContext.setInformation(NLS.bind((String)Messages.DependencyUpdateRefactoring_warningTransitiveDependencyNotManagedInfo, (Object)one.getProject().getName(), (Object)this.buildParentsString(one)));
                    status.addWarning(NLS.bind((String)Messages.DependencyUpdateRefactoring_warningTransitiveDependencyNotManaged, (Object)one.getProject().getName()), (RefactoringStatusContext)dependencyUpdateRefContext);
                    for (UIDependencyElement tr : trans) {
                        UpdateDependencyOperation update = new UpdateDependencyOperation(tr);
                        update.setManaged(true);
                        update.setRawArtifactId(tr.getMavenArtifactKey().getArtifactId());
                        update.setRawGroupId(tr.getMavenArtifactKey().getGroupId());
                        update.setNewVersionValue(tr.getUpdateVersion().toString());
                        one.resolve(update, tr);
                    }
                }
            }
            if (others.size() <= 0) continue;
            DependencyUpdateRefContext cont = new DependencyUpdateRefContext(DependencyUpdateRefContext.Type.NOT_FOUND_IN_WORKSPACE);
            cont.setProjects(Collections.singletonList(one.getProject()));
            cont.setDependencyElements(others);
            cont.setInformation(NLS.bind((String)Messages.DependencyUpdateRefactoring_warningDependencyNotLocatedInfo, (Object)one.getProject().getName(), (Object)this.buildParentsString(one)));
            status.addError(NLS.bind((String)Messages.DependencyUpdateRefactoring_warningDependencyNotLocated, (Object)one.getProject().getName()), (RefactoringStatusContext)cont);
        }
        for (MultiPropertyRefContext context : this.propertyContexts) {
            String version = context.getPropertyLocationOperation().getNewVersionValue();
            for (UIDependencyElement element : this.getElements(context)) {
                this.versionAvailable.put(element, DependencyUpdateRefactoring.hasVersion(client, element, version));
                if (!pm.isCanceled()) continue;
                return RefactoringStatus.createFatalErrorStatus((String)Messages.DependencyUpdateRefactoring_cancel);
            }
        }
        return status;
    }

    public static Boolean hasVersion(RestClient client, UIDependencyElement element, String version) {
        ArtifactKey gav = element.getMavenArtifactKey();
        UrlBuilder url = new UrlBuilder(InsightClientManager.getInstance().getServerUrl());
        url.appendPath("rest/ide/component/versions");
        url.appendQueryParam("groupId", gav.getGroupId());
        url.appendQueryParam("artifactId", gav.getArtifactId());
        try {
            String[] versions = client.get(url.build(), String[].class);
            if (versions == null) {
                throw new IOException("Received empty response from Nexus IQ Server for request " + url.build());
            }
            String[] stringArray = versions;
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (v.equals(version)) {
                    return Boolean.TRUE;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", "Could not check availability of " + gav.getGroupId() + ":" + gav.getArtifactId() + ":" + version, (Throwable)e));
        }
        return Boolean.FALSE;
    }

    private boolean comesViaWorkspaceProject(MavenProject mavenProject, UIDependencyElement tr, Set<OneProject> onePrjs) {
        Artifact found = null;
        for (Artifact art : mavenProject.getArtifacts()) {
            if (!art.getGroupId().equals(tr.getMavenArtifactKey().getGroupId()) || !art.getArtifactId().equals(tr.getMavenArtifactKey().getArtifactId())) continue;
            found = art;
            break;
        }
        if (found != null) {
            List trails = found.getDependencyTrail();
            for (String trail : trails) {
                if (trail.startsWith(mavenProject.getGroupId() + ":" + mavenProject.getArtifactId() + ":")) continue;
                for (OneProject one : onePrjs) {
                    if (!trail.startsWith(one.getMavenProject().getGroupId() + ":" + one.getMavenProject().getArtifactId() + ":")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private String buildParentsString(OneProject one) {
        StringBuffer parents = new StringBuffer();
        OneProject curr = one;
        while (curr.getParent() != null) {
            parents.append(curr.getParent().getProject().getName());
            curr = curr.getParent();
            if (curr.getParent() == null) continue;
            parents.append(", ");
        }
        if (parents.length() > 0) {
            parents.insert(0, " (");
            parents.append(')');
        }
        return parents.toString();
    }

    private void collectInformationOnProject(RefactoringStatus status, OneProject one) throws CoreException {
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(one.getProject());
        if (facade == null) {
            one.setUsedPropertiesMap(new HashMap<String, List<String>>());
            one.setDefinedPropertiesMap(new HashMap<String, List<String>>());
            return;
        }
        IFile pomFile = facade.getPom();
        MavenProject mp = one.getMavenProject();
        ArrayList<String> activatedProfiles = new ArrayList<String>();
        for (Profile prof : mp.getActiveProfiles()) {
            activatedProfiles.add(prof.getId());
        }
        ArrayList<FindDependencyOperation> operations = new ArrayList<FindDependencyOperation>();
        CollectVersionPropertiesOperation collectProps = new CollectVersionPropertiesOperation(activatedProfiles);
        for (UIDependencyElement el : one.getRecursiveUnresolvedUpdates()) {
            operations.add(new FindDependencyOperation(el, mp, activatedProfiles, el.getUpdateVersion().toString()));
        }
        try {
            ArrayList<Object> all = new ArrayList<Object>();
            all.add(collectProps);
            all.addAll(operations);
            IDocument doc = this.getDocumentForFile(pomFile);
            PomEdits.OperationTuple tuple = doc != null ? new PomEdits.OperationTuple(doc, (PomEdits.Operation)new PomEdits.CompoundOperation(all.toArray(new PomEdits.Operation[0])), true) : new PomEdits.OperationTuple(pomFile, (PomEdits.Operation)new PomEdits.CompoundOperation(all.toArray(new PomEdits.Operation[0])));
            if (pomFile.isSynchronized(0)) {
                PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{tuple});
            } else {
                status.addError(NLS.bind((String)Messages.DependencyUpdateRefactoring_warningPomFileOutOfSync, (Object)pomFile.getFullPath()));
            }
            Map<String, List<String>> propUsedBy = collectProps.getResult();
            one.setUsedPropertiesMap(propUsedBy);
            one.setDefinedPropertiesMap(collectProps.getDefinedProperties());
            one.getUnresolvedOperations().addAll(operations);
        }
        catch (IOException e) {
            status.addError(e.getMessage());
        }
    }

    private IDocument getDocumentForFile(final IFile file) {
        if (Display.getCurrent() == null) {
            final IDocument[] doc = new IDocument[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    doc[0] = DependencyUpdateRefactoring.this.getDocumentForFile(file);
                }
            });
            if (doc[0] != null) {
                return doc[0];
            }
            return null;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n = iWorkbenchPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n3 = iEditorReferenceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IDocumentProvider provider;
                    IFileEditorInput fileInput;
                    IEditorInput input;
                    IEditorReference editRef = iEditorReferenceArray[n4];
                    IEditorPart editor = editRef.getEditor(false);
                    if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && file.equals((Object)(fileInput = (IFileEditorInput)input).getFile()) && (provider = DocumentProviderRegistry.getDefault().getDocumentProvider(input)) != null) {
                        IDocument toRet = provider.getDocument((Object)input);
                        return toRet;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    private Set<OneProject> constructProjectHierarchies(Set<Map.Entry<IProject, List<UIDependencyElement>>> set, IProgressMonitor pm) throws CoreException {
        HashSet<OneProject> toRet = new HashSet<OneProject>();
        block0: for (Map.Entry<IProject, List<UIDependencyElement>> ent : set) {
            IProject prj = ent.getKey();
            if (!prj.hasNature("org.eclipse.m2e.core.maven2Nature")) continue;
            IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(prj);
            if (facade == null) break;
            MavenProject mp = facade.getMavenProject(pm);
            OneProject one = new OneProject(prj, mp);
            if (!toRet.contains(one)) {
                toRet.add(one);
            }
            one.getUnresolvedUpdates().addAll((Collection<UIDependencyElement>)ent.getValue());
            MavenProjectHierarchy heirarchy = new MavenProjectHierarchy();
            boolean first = true;
            for (IMavenProjectFacade parent : heirarchy.getHierarchy(facade, pm)) {
                if (first) {
                    first = false;
                    continue;
                }
                if (parent == null) continue block0;
                OneProject parentOne = new OneProject(parent.getProject(), parent.getMavenProject(pm));
                if (toRet.contains(parentOne)) {
                    for (OneProject ex : toRet) {
                        if (!ex.equals(parentOne)) continue;
                        parentOne = ex;
                        break;
                    }
                } else {
                    toRet.add(parentOne);
                }
                parentOne.addChild(one);
                one.setParent(parentOne);
                one = parentOne;
            }
        }
        return toRet;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        for (MultiPropertyRefContext cont : this.getPropertyContexts()) {
            if (cont.isWriteAsProperty()) {
                for (Map.Entry<OneProject, List<UpdateDependencyOperation>> ent : cont.getNonPropUpdates().entrySet()) {
                    for (UpdateDependencyOperation op : ent.getValue()) {
                        ent.getKey().getResolvedOperations().remove(op);
                    }
                }
                cont.getPropertyLocationProject().resolve(cont.getPropertyLocationOperation(), null);
                continue;
            }
            cont.getPropertyLocationProject().getResolvedOperations().remove(cont.getPropertyLocationOperation());
            for (Map.Entry<OneProject, List<UpdateDependencyOperation>> ent : cont.getNonPropUpdates().entrySet()) {
                for (UpdateDependencyOperation op : ent.getValue()) {
                    ent.getKey().resolve(op, null);
                }
            }
        }
        this.mavenUpdates = new HashMap<IFile, List<? extends PomEdits.Operation>>();
        for (OneProject one : this.oneProjects) {
            if (one.getResolvedOperations().size() <= 0) continue;
            IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(one.getProject());
            IFile pomFile = facade.getPom();
            this.mavenUpdates.put(pomFile, one.getResolvedOperations());
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange toRet = new CompositeChange(Messages.DependencyUpdateRefactoring_changeTitle);
        ArrayList<IFile> order = new ArrayList<IFile>(this.mavenUpdates.size());
        block0: for (Map.Entry<IFile, List<? extends PomEdits.Operation>> one : this.mavenUpdates.entrySet()) {
            for (PomEdits.Operation operation : one.getValue()) {
                UpdateDependencyOperation dep;
                if (!(operation instanceof UpdateDependencyOperation) || !(dep = (UpdateDependencyOperation)operation).isWriteAsProperty()) continue;
                order.add(0, one.getKey());
                continue block0;
            }
            order.add(one.getKey());
        }
        for (IFile file : order) {
            List<? extends PomEdits.Operation> list = this.mavenUpdates.get(file);
            toRet.add((Change)PomHelper.createChange((IFile)file, (PomEdits.Operation)new PomEdits.CompoundOperation(list.toArray(new PomEdits.Operation[0])), (String)(file.getName() + " - " + file.getProject().getName())));
        }
        return toRet;
    }

    public void clearUpdatedVersions() {
        if (this.mavenUpdates != null) {
            Collection<List<? extends PomEdits.Operation>> vals = this.mavenUpdates.values();
            for (List<? extends PomEdits.Operation> val : vals) {
                for (PomEdits.Operation operation : val) {
                    UpdateDependencyOperation update;
                    if (!(operation instanceof UpdateDependencyOperation) || (update = (UpdateDependencyOperation)operation).getFindAssociate() == null) continue;
                    update.getFindAssociate().setUpdateVersion(null);
                }
            }
        }
        for (MultiPropertyRefContext cont : this.getPropertyContexts()) {
            for (List<UpdateDependencyOperation> lst : cont.getNonPropUpdates().values()) {
                for (UpdateDependencyOperation op : lst) {
                    if (op.getFindAssociate() == null) continue;
                    op.getFindAssociate().setUpdateVersion(null);
                }
            }
        }
        for (UIDependencyElement el : this.additionalUpdateVersionsToClear) {
            el.setUpdateVersion(null);
        }
    }

    Map<UIDependencyElement, Boolean> getVersionAvailable() {
        return this.versionAvailable;
    }

    public Collection<MultiPropertyRefContext> getPropertyContexts() {
        return this.propertyContexts;
    }

    private Collection<UIDependencyElement> getElements(MultiPropertyRefContext context) {
        LinkedList<UIDependencyElement> elements = new LinkedList<UIDependencyElement>();
        block0: for (UIDependencyElement element : this.provider.getDependencyElements()) {
            ArtifactKey key = element.getMavenArtifactKey();
            if (key == null) continue;
            for (String gaStr : context.getDependenciesUsingProperty()) {
                String[] ga = gaStr.split(":");
                if (ga == null || ga.length != 2 || !key.getGroupId().equals(ga[0]) || !key.getArtifactId().equals(ga[1])) continue;
                elements.add(element);
                continue block0;
            }
        }
        return elements;
    }

    static class OneProject {
        private final IProject current;
        private final MavenProject mavenProject;
        private OneProject parent;
        private final Set<OneProject> childs = new HashSet<OneProject>();
        Map<String, List<String>> propUsedByDependency = new HashMap<String, List<String>>();
        Map<String, List<String>> propsDefined;
        private final List<UpdateDependencyOperation> resolvedOperations = new ArrayList<UpdateDependencyOperation>();
        private final List<UpdateDependencyOperation> propertyCandidateOperations = new ArrayList<UpdateDependencyOperation>();
        private final List<FindDependencyOperation> unresolvedOperations = new ArrayList<FindDependencyOperation>();
        private final List<UIDependencyElement> unresolvedUpdates = new ArrayList<UIDependencyElement>();
        private boolean processed = false;

        public OneProject(IProject curr, MavenProject maven) {
            if (curr == null) {
                throw new IllegalArgumentException();
            }
            if (maven == null) {
                throw new IllegalArgumentException();
            }
            this.current = curr;
            this.mavenProject = maven;
        }

        public void addPropertyCandidate(UpdateDependencyOperation update) {
            if (update != null) {
                this.propertyCandidateOperations.add(update);
            }
        }

        public OneProject findOneWithPropertyCandidate(UpdateDependencyOperation oper) {
            if (this.propertyCandidateOperations.contains(oper)) {
                return this;
            }
            for (OneProject child : this.getChilds()) {
                OneProject found = child.findOneWithPropertyCandidate(oper);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        public void removePropertyCandidate(UpdateDependencyOperation oper) {
            this.propertyCandidateOperations.remove(oper);
        }

        public List<UpdateDependencyOperation> getRecursivePropertyWritingCandidates() {
            ArrayList<UpdateDependencyOperation> toRet = new ArrayList<UpdateDependencyOperation>();
            toRet.addAll(this.getPropertyWritingCandidates());
            for (OneProject child : this.getChilds()) {
                toRet.addAll(child.getRecursivePropertyWritingCandidates());
            }
            return toRet;
        }

        private List<UpdateDependencyOperation> getPropertyWritingCandidates() {
            ArrayList<UpdateDependencyOperation> toRet = new ArrayList<UpdateDependencyOperation>();
            for (UpdateDependencyOperation op : this.propertyCandidateOperations) {
                toRet.add(op);
            }
            return toRet;
        }

        public void setDefinedPropertiesMap(Map<String, List<String>> definedProperties) {
            this.propsDefined = definedProperties;
        }

        public Map<String, List<String>> getDefinedPropertiesMap() {
            return this.propsDefined;
        }

        public void resolve(UpdateDependencyOperation update, UIDependencyElement op) {
            if (update != null) {
                this.resolvedOperations.add(update);
                if (this.propertyCandidateOperations.contains(update)) {
                    this.propertyCandidateOperations.remove(update);
                }
            }
            if (op != null) {
                Iterator<FindDependencyOperation> it = this.unresolvedOperations.iterator();
                while (it.hasNext()) {
                    FindDependencyOperation find = it.next();
                    if (!find.getElement().equals(op)) continue;
                    it.remove();
                }
                this.unresolvedUpdates.remove(op);
                for (OneProject child : this.getChilds()) {
                    child.resolve(null, op);
                }
            }
        }

        public void setUsedPropertiesMap(Map<String, List<String>> propUsedBy) {
            this.propUsedByDependency.clear();
            this.propUsedByDependency.putAll(propUsedBy);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.getProject() == null ? 0 : this.getProject().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OneProject other = (OneProject)obj;
            return !(this.getProject() == null ? other.getProject() != null : !this.getProject().equals((Object)other.getProject()));
        }

        public OneProject getParent() {
            return this.parent;
        }

        public void setParent(OneProject parent) {
            this.parent = parent;
        }

        public Set<OneProject> getChilds() {
            return this.childs;
        }

        public void addChild(OneProject project) {
            this.childs.add(project);
        }

        public List<UpdateDependencyOperation> getResolvedOperations() {
            return this.resolvedOperations;
        }

        public List<FindDependencyOperation> getUnresolvedOperations() {
            return this.unresolvedOperations;
        }

        public boolean isProcessed() {
            return this.processed;
        }

        private void collectChildren(List<OneProject> collect, OneProject one) {
            for (OneProject child : one.getChilds()) {
                collect.add(child);
                this.collectChildren(collect, child);
            }
        }

        public boolean isChildrenProcessed() {
            ArrayList<OneProject> collect = new ArrayList<OneProject>();
            this.collectChildren(collect, this);
            for (OneProject child : collect) {
                if (child.isProcessed()) continue;
                return false;
            }
            return true;
        }

        public void setProcessed(boolean processed) {
            this.processed = processed;
        }

        public Set<String> getDepsUsingVersionProperty(String propertyName, boolean recursive) {
            HashSet<String> toRet = new HashSet<String>();
            List<String> one = this.propUsedByDependency.get(propertyName);
            if (one != null) {
                toRet.addAll(one);
            }
            if (recursive) {
                for (OneProject child : this.getChilds()) {
                    toRet.addAll(child.getDepsUsingVersionProperty(propertyName, true));
                }
            }
            return toRet;
        }

        public MavenProject getMavenProject() {
            return this.mavenProject;
        }

        public List<UIDependencyElement> getRecursiveUnresolvedUpdates() {
            ArrayList<UIDependencyElement> toRet = new ArrayList<UIDependencyElement>(this.unresolvedUpdates);
            for (OneProject child : this.getChilds()) {
                toRet.addAll(child.getRecursiveUnresolvedUpdates());
            }
            return toRet;
        }

        public List<UIDependencyElement> getUnresolvedUpdates() {
            return this.unresolvedUpdates;
        }

        public IProject getProject() {
            return this.current;
        }
    }
}

