/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.edit;

import com.sonatype.insight.ide.eclipse.internal.ArtifactKey;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ui.Controller;
import com.sonatype.insight.ide.eclipse.internal.ui.DependencyContentProvider;
import com.sonatype.insight.ide.eclipse.internal.ui.edit.DependencyUpdateRefactoring;
import com.sonatype.insight.ide.eclipse.internal.ui.edit.MultiPropertyRefContext;
import com.sonatype.insight.ide.eclipse.internal.ui.edit.UpdatePropertyPage;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class DependencyUpdateWizard
extends RefactoringWizard {
    private final DependencyContentProvider provider;

    public DependencyUpdateWizard(Collection<IProject> projects, UIDependencyElement element, DependencyContentProvider provider) {
        super((Refactoring)new DependencyUpdateRefactoring(projects, element, provider), 2);
        this.provider = provider;
    }

    protected void addUserInputPages() {
        this.setDefaultPageTitle(this.getRefactoring().getName());
        Collection<MultiPropertyRefContext> contexts = this.getDepRefactoring().getPropertyContexts();
        for (MultiPropertyRefContext context : contexts) {
            LinkedList<UIDependencyElement> elements = new LinkedList<UIDependencyElement>();
            block1: for (UIDependencyElement element : this.provider.getDependencyElements()) {
                ArtifactKey key = element.getMavenArtifactKey();
                if (key == null) continue;
                for (String gaStr : context.getDependenciesUsingProperty()) {
                    String[] ga = gaStr.split(":");
                    if (ga == null || ga.length != 2 || !key.getGroupId().equals(ga[0]) || !key.getArtifactId().equals(ga[1])) continue;
                    elements.add(element);
                    continue block1;
                }
            }
            Collection<UIDependencyElement> el = context.getDependencyElements();
            if (el.isEmpty()) continue;
            this.addPage((IWizardPage)new UpdatePropertyPage(context, elements, el, this.getDepRefactoring().getVersionAvailable()));
        }
    }

    public boolean performFinish() {
        boolean finished = super.performFinish();
        if (finished) {
            DependencyUpdateRefactoring ref = (DependencyUpdateRefactoring)this.getRefactoring();
            ref.clearUpdatedVersions();
        }
        return finished;
    }

    public DependencyUpdateRefactoring getDepRefactoring() {
        return (DependencyUpdateRefactoring)this.getRefactoring();
    }

    public static int open(UIDependencyElement element, Controller controller) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IProject[] projects = controller.getCache().getActiveProjects();
        DependencyUpdateWizard wizard = new DependencyUpdateWizard(Arrays.asList(projects), element, controller.getProvider());
        try {
            String titleForFailedChecks = "";
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            return op.run(shell, titleForFailedChecks);
        }
        catch (InterruptedException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", Messages.DependencyUpdateWizard_error, (Throwable)e));
            Thread.currentThread().interrupt();
            return -1;
        }
    }
}

