/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.edit;

import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ui.edit.DependencyUpdateRefContext;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.ui.refactoring.IStatusContextViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StatusContextViewerImpl
implements IStatusContextViewer {
    private Composite comp;
    private Text text;

    public void createControl(Composite parent) {
        this.comp = new Composite(parent, 0);
        this.comp.setLayout((Layout)new GridLayout(1, false));
        Label lblAdditionalInformation = new Label(this.comp, 0);
        lblAdditionalInformation.setText(Messages.StatusContextViewerImpl_additionalInfo);
        this.text = new Text(this.comp, 2634);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    public Control getControl() {
        return this.comp;
    }

    public void setInput(RefactoringStatusContext input) {
        assert (input instanceof DependencyUpdateRefContext);
        DependencyUpdateRefContext ref = (DependencyUpdateRefContext)input;
        StringBuffer buff = new StringBuffer();
        if (ref.getInformation() != null) {
            buff.append(ref.getInformation());
            buff.append("\n\n");
        }
        if (ref.getProjects() != null) {
            buff.append(Messages.StatusContextViewerImpl_affectedProjects);
            for (IProject prj : ref.getProjects()) {
                buff.append("    ").append(prj.getName()).append('\n');
            }
            buff.append('\n');
        }
        if (ref.getDependencyElements() != null) {
            buff.append(Messages.StatusContextViewerImpl_affectedComponents);
            for (UIDependencyElement dep : ref.getDependencyElements()) {
                buff.append("    ").append(dep.getName()).append('\n');
            }
            buff.append('\n');
        }
        this.text.setText(buff.toString());
    }
}

