/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.edit;

import com.sonatype.insight.ide.eclipse.Images;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ui.DependencyLabelProvider;
import com.sonatype.insight.ide.eclipse.internal.ui.edit.MultiPropertyRefContext;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.ComparableVersion;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class UpdatePropertyPage
extends UserInputWizardPage {
    private Table table;
    private boolean addDependencyManagement;
    private Collection<UIDependencyElement> elementsNotUpdated;
    private String property;
    private ComparableVersion upgradeVersion;
    private Collection<UIDependencyElement> elementsUpdated;
    private MultiPropertyRefContext context;
    private Map<UIDependencyElement, Boolean> versionAvailable;

    public UpdatePropertyPage(MultiPropertyRefContext context, Collection<UIDependencyElement> elementsNotUpdated, Collection<UIDependencyElement> elementsUpdated, Map<UIDependencyElement, Boolean> versionAvailable) {
        super("versionProperty:" + String.valueOf((Object)context));
        this.setTitle(Messages.UpdatePropertyPage_title);
        this.setDescription(Messages.UpdatePropertyPage_description);
        assert (!elementsUpdated.isEmpty());
        this.context = context;
        this.elementsNotUpdated = elementsNotUpdated;
        this.property = context.getProperty();
        this.elementsUpdated = elementsUpdated;
        this.upgradeVersion = elementsUpdated.iterator().next().getUpdateVersion();
        this.versionAvailable = versionAvailable;
        this.addDependencyManagement = false;
    }

    public void createControl(Composite parent) {
        this.context.setWriteAsProperty(true);
        for (UIDependencyElement element : this.elementsNotUpdated) {
            if (this.isUpgradeVersionAvailable(element)) continue;
            this.addDependencyManagement = true;
            this.context.setWriteAsProperty(false);
            break;
        }
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        Label lblVersionDefinedIn = new Label(container, 0);
        lblVersionDefinedIn.setText(NLS.bind((String)Messages.UpdatePropertyPage_longDesc, (Object[])new Object[]{this.getElementsUpdated(), this.upgradeVersion.toString(), this.property}));
        TableViewer tableViewer = new TableViewer(container, 67584);
        this.table = tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new DependencyLabelProvider());
        TableColumn tblclmnDependency = tableViewerColumn.getColumn();
        tblclmnDependency.setWidth(172);
        tblclmnDependency.setText(Messages.UpdatePropertyPage_colComponent);
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, 0);
        tableViewerColumn_1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof UIDependencyElement) {
                    return UpdatePropertyPage.this.isUpgradeVersionAvailable((UIDependencyElement)element) ? Messages.UpdatePropertyPage_versionAvailable : Messages.UpdatePropertyPage_versionNotAvailable;
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof UIDependencyElement) {
                    return UpdatePropertyPage.this.isUpgradeVersionAvailable((UIDependencyElement)element) ? Images.getImage("obj16/passed.png") : Images.getImage("obj16/error_st_obj.gif");
                }
                return null;
            }
        });
        TableColumn tblclmnVersionAvailable = tableViewerColumn_1.getColumn();
        tblclmnVersionAvailable.setWidth(135);
        tblclmnVersionAvailable.setText(Messages.UpdatePropertyPage_colVersionAvailable);
        Group group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        group.setText(Messages.UpdatePropertyPage_updateText);
        final Button btnUpdateProperty = new Button((Composite)group, 16);
        btnUpdateProperty.setText(Messages.UpdatePropertyPage_btnProperty);
        btnUpdateProperty.setSelection(!this.addDependencyManagement);
        Button btnAddDependencyManagement = new Button((Composite)group, 16);
        btnAddDependencyManagement.setText(Messages.UpdatePropertyPage_btnVersion);
        btnAddDependencyManagement.setSelection(this.addDependencyManagement);
        SelectionAdapter selection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdatePropertyPage.this.context.setWriteAsProperty(e.widget == btnUpdateProperty);
            }
        };
        btnUpdateProperty.addSelectionListener((SelectionListener)selection);
        btnAddDependencyManagement.addSelectionListener((SelectionListener)selection);
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        tableViewer.setInput(this.elementsNotUpdated);
    }

    public String getProperty() {
        return this.property;
    }

    private boolean isUpgradeVersionAvailable(UIDependencyElement element) {
        return Boolean.TRUE.equals(this.versionAvailable.get(element));
    }

    private String getElementsUpdated() {
        StringBuilder sb = new StringBuilder();
        for (UIDependencyElement element : this.elementsUpdated) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(element.getName());
        }
        return sb.toString();
    }
}

