/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.elements;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;

public class ComparableVersion
implements Comparable<ComparableVersion> {
    private final String value;
    private final String canonical;
    private final ListItem items;
    private static final String[] NON_FCS_QUALIFIERS = new String[]{"rc", "beta", "alpha"};

    public ComparableVersion(String version) {
        this.value = version;
        this.items = new ListItem();
        version = version.toLowerCase(Locale.ENGLISH);
        ListItem list = this.items;
        Stack<ListItem> stack = new Stack<ListItem>();
        stack.push(list);
        boolean isDigit = false;
        int startIndex = 0;
        int i = 0;
        while (i < version.length()) {
            char c = version.charAt(i);
            if (c == '.') {
                if (i == startIndex) {
                    list.add(IntegerItem.ZERO);
                } else {
                    list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex, i)));
                }
                startIndex = i + 1;
            } else if (c == '-') {
                if (i == startIndex) {
                    list.add(IntegerItem.ZERO);
                } else {
                    list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex, i)));
                }
                startIndex = i + 1;
                if (isDigit) {
                    list.normalize();
                    if (i + 1 < version.length() && Character.isDigit(version.charAt(i + 1))) {
                        ListItem listItem = list;
                        list = new ListItem();
                        listItem.add(list);
                        stack.push(list);
                    }
                }
            } else if (Character.isDigit(c)) {
                if (!isDigit && i > startIndex) {
                    list.add(new StringItem(version.substring(startIndex, i), true));
                    startIndex = i;
                }
                isDigit = true;
            } else {
                if (isDigit && i > startIndex) {
                    list.add(ComparableVersion.parseItem(true, version.substring(startIndex, i)));
                    startIndex = i;
                }
                isDigit = false;
            }
            ++i;
        }
        if (version.length() > startIndex) {
            list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex)));
        }
        while (!stack.isEmpty()) {
            list = (ListItem)stack.pop();
            list.normalize();
        }
        this.canonical = this.items.toString();
    }

    private static Item parseItem(boolean isDigit, String buf) {
        return isDigit ? new IntegerItem(buf) : new StringItem(buf, false);
    }

    @Override
    public int compareTo(ComparableVersion o) {
        return this.items.compareTo(o.items);
    }

    public boolean equals(Object o) {
        return o instanceof ComparableVersion && this.canonical.equals(((ComparableVersion)o).canonical);
    }

    public int hashCode() {
        return this.canonical.hashCode();
    }

    public String toString() {
        return this.value;
    }

    public boolean isMajorUpdate(ComparableVersion version) {
        ListItem other = version.items;
        if (this.isNonFCS() && version.isSnapshot()) {
            return false;
        }
        if (!this.isSnapshot() && !this.isNonFCS() && (version.isNonFCS() || version.isSnapshot())) {
            return false;
        }
        if (this.compareTo(version) < 0) {
            return this.items.size() > 0 && other.size() > 0 && ((Item)this.items.get(0)).compareTo((Item)other.get(0)) < 0;
        }
        return false;
    }

    public boolean isMinorUpdate(ComparableVersion version) {
        if (this.isNonFCS() && version.isSnapshot()) {
            return false;
        }
        if (!this.isSnapshot() && !this.isNonFCS() && (version.isNonFCS() || version.isSnapshot())) {
            return false;
        }
        if (this.compareTo(version) < 0) {
            ListItem[] other = ComparableVersion.split(version.items);
            return other[0].size() > 1 && this.equals(other[0], 0) && this.lessThan(other[0], 1);
        }
        return false;
    }

    public boolean isMicroUpdate(ComparableVersion version) {
        if (this.compareTo(version) >= 0) {
            return false;
        }
        boolean nonFCS = this.isNonFCS();
        boolean snapshot = this.isSnapshot();
        boolean otherNonFCS = version.isNonFCS();
        boolean otherSnapshot = version.isSnapshot();
        if (ComparableVersion.split(this.items)[0].compareTo(ComparableVersion.split(version.items)[0]) == 0) {
            if (snapshot && otherNonFCS) {
                return true;
            }
            if (nonFCS && otherNonFCS) {
                return this.compareTo(version) < 0;
            }
            return false;
        }
        if (!snapshot && !nonFCS && (otherNonFCS || otherSnapshot)) {
            return false;
        }
        ListItem[] other = ComparableVersion.split(version.items);
        return other[0].size() > 2 && this.equals(other[0], 0) && this.equals(other[0], 1) && this.lessThan(other[0], 2);
    }

    private boolean equals(ListItem b, int index) {
        return this.items.size() > index && ((Item)this.items.get(index)).equals(b.get(index)) || this.items.size() <= index && IntegerItem.ZERO.equals(b.get(index));
    }

    private boolean lessThan(ListItem b, int index) {
        return this.items.size() > index && ((Item)this.items.get(index)).compareTo((Item)b.get(index)) < 0 || this.items.size() <= index && IntegerItem.ZERO.compareTo((Item)b.get(index)) < 0;
    }

    private static ListItem[] split(ListItem items) {
        ListItem[] results = new ListItem[]{new ListItem(), new ListItem()};
        ListItem section = results[0];
        for (Item item : items) {
            if (item instanceof StringItem) {
                section = results[1];
            }
            section.add(item);
        }
        return results;
    }

    public boolean isRelease(ComparableVersion version) {
        ListItem thisUnqualified;
        if (!this.isNonFCS() && !this.isSnapshot() || version.isNonFCS() || version.isSnapshot() || this.compareTo(version) >= 0) {
            return false;
        }
        ListItem otherUnqualified = ComparableVersion.split(version.items)[0];
        return otherUnqualified.compareTo(thisUnqualified = ComparableVersion.split(this.items)[0]) >= 0;
    }

    private boolean isNonFCS() {
        for (Item item : this.items) {
            if (!(item instanceof StringItem)) continue;
            String[] stringArray = NON_FCS_QUALIFIERS;
            int n = NON_FCS_QUALIFIERS.length;
            int n2 = 0;
            while (n2 < n) {
                String q = stringArray[n2];
                if (q.equals(item.toString())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isSnapshot() {
        for (Item item : this.items) {
            if (!(item instanceof StringItem) || !"snapshot".equals(item.toString())) continue;
            return true;
        }
        return false;
    }

    private static class IntegerItem
    implements Item {
        private final BigInteger value;
        public static final IntegerItem ZERO = new IntegerItem();

        private IntegerItem() {
            this.value = BigInteger.ZERO;
        }

        public IntegerItem(String str) {
            this.value = new BigInteger(str);
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public boolean isNull() {
            return BigInteger.ZERO.equals(this.value);
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return BigInteger.ZERO.equals(this.value) ? 0 : 1;
            }
            switch (item.getType()) {
                case 0: {
                    return this.value.compareTo(((IntegerItem)item).value);
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
            }
            throw new RuntimeException("invalid item: " + String.valueOf(item.getClass()));
        }

        public boolean equals(Object o) {
            return this.compareTo((Item)o) == 0;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static interface Item {
        public static final int INTEGER_ITEM = 0;
        public static final int STRING_ITEM = 1;
        public static final int LIST_ITEM = 2;

        public int compareTo(Item var1);

        public int getType();

        public boolean isNull();
    }

    private static class ListItem
    extends ArrayList<Item>
    implements Item {
        private ListItem() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public boolean isNull() {
            return this.size() == 0;
        }

        void normalize() {
            ListIterator iterator = this.listIterator(this.size());
            while (iterator.hasPrevious()) {
                Item item = (Item)iterator.previous();
                if (!item.isNull()) break;
                iterator.remove();
            }
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                if (this.size() == 0) {
                    return 0;
                }
                Item first = (Item)this.get(0);
                return first.compareTo(null);
            }
            switch (item.getType()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    Iterator left = this.iterator();
                    Iterator right = ((ListItem)item).iterator();
                    while (left.hasNext() || right.hasNext()) {
                        int result;
                        Item l = left.hasNext() ? (Item)left.next() : null;
                        Item r = right.hasNext() ? (Item)right.next() : null;
                        int n = result = l == null ? -r.compareTo(l) : l.compareTo(r);
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }
            }
            throw new RuntimeException("invalid item: " + String.valueOf(item.getClass()));
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append('(');
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                buffer.append(iter.next());
                if (!iter.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append(')');
            return buffer.toString();
        }
    }

    private static class StringItem
    implements Item {
        private static final Map<String, String> QUALIFIERS = new HashMap<String, String>();
        private static final Map<String, String> ALIASES = new HashMap<String, String>();
        private static final String RELEASE_VERSION_INDEX;
        private static final String LEXICAL_PREFIX;
        private final String value;

        static {
            String[] qualifiers = new String[]{"alpha", "beta", "milestone", "rc", "snapshot", "", "sp"};
            int i = 0;
            while (i < qualifiers.length) {
                QUALIFIERS.put(qualifiers[i], String.valueOf(i));
                ++i;
            }
            ALIASES.put("ga", "");
            ALIASES.put("final", "");
            ALIASES.put("cr", "rc");
            RELEASE_VERSION_INDEX = QUALIFIERS.get("");
            LEXICAL_PREFIX = String.valueOf(QUALIFIERS.size());
        }

        public StringItem(String value, boolean followedByDigit) {
            String alias;
            if (followedByDigit && value.length() == 1) {
                switch (value.charAt(0)) {
                    case 'a': {
                        value = "alpha";
                        break;
                    }
                    case 'b': {
                        value = "beta";
                        break;
                    }
                    case 'm': {
                        value = "milestone";
                    }
                }
            }
            this.value = (alias = ALIASES.get(value)) != null ? alias : value;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean isNull() {
            return this.value.length() <= 0;
        }

        private static String comparableQualifier(String qualifier) {
            String i = QUALIFIERS.get(qualifier);
            return i != null ? i : LEXICAL_PREFIX + qualifier;
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX);
            }
            switch (item.getType()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return StringItem.comparableQualifier(this.value).compareTo(StringItem.comparableQualifier(((StringItem)item).value));
                }
                case 2: {
                    return -1;
                }
            }
            throw new IllegalStateException("invalid item: " + String.valueOf(item.getClass()));
        }

        public boolean equals(Object o) {
            return this.compareTo((Item)o) == 0;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value;
        }
    }
}

