/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.elements;

import com.sonatype.clm.dto.model.policy.PolicyAlert;
import com.sonatype.insight.ide.eclipse.Images;
import com.sonatype.insight.ide.eclipse.internal.ArtifactKey;
import com.sonatype.insight.ide.eclipse.internal.helpers.MavenHelper;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.ComparableVersion;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.ComponentKey;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class JavaDependencyElement
implements UIDependencyElement {
    private Set<IProject> projects = Collections.newSetFromMap(new ConcurrentHashMap());
    private ArtifactKey artifactKey;
    private ArtifactKey declaredArtifactKey;
    private ComparableVersion version;
    private ComparableVersion updateVersion;
    private final ComponentKey key;
    private volatile boolean transitive;
    private final AtomicBoolean transitiveDirty = new AtomicBoolean();
    private volatile boolean loaded;
    private UIDependencyElement.MatchState matchState;
    private int errorCode;
    private String errorMessage;
    private Collection<PolicyAlert> alerts;
    private String hash;
    private boolean proprietary;
    private final TransitivityProcessor transitivityExecutor;

    public JavaDependencyElement(ComponentKey key, IProject project, ArtifactKey gav, TransitivityProcessor transitivityExecutor) {
        if (key == null) {
            throw new IllegalArgumentException("component key missing");
        }
        this.key = key;
        this.transitivityExecutor = transitivityExecutor;
        this.setMavenArtifactKey(gav);
        this.add(project);
    }

    @Override
    public String getName() {
        return this.artifactKey == null ? this.key.getFile().getName() : this.artifactKey.getArtifactId();
    }

    @Override
    public ComponentKey getComponentKey() {
        return this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaDependencyElement)) {
            return false;
        }
        JavaDependencyElement that = (JavaDependencyElement)other;
        return this.key.equals(that.key);
    }

    @Override
    public ArtifactKey getMavenArtifactKey() {
        return this.artifactKey;
    }

    @Override
    public void setMavenArtifactKey(ArtifactKey key) {
        if (this.artifactKey != null && this.declaredArtifactKey == null && !this.artifactKey.equals(key)) {
            this.declaredArtifactKey = this.artifactKey;
        }
        this.artifactKey = key;
        if (key != null) {
            this.version = new ComparableVersion(key.getVersion());
        }
    }

    @Override
    public ArtifactKey getDeclaredArtifactKey() {
        return this.declaredArtifactKey != null ? this.declaredArtifactKey : this.artifactKey;
    }

    @Override
    public ComparableVersion getCurrentVersion() {
        return this.version;
    }

    public Image getImage() {
        ImageDescriptor base = Images.DESC_JAR;
        if (this.isLoaded() && this.getMatchState() == null) {
            return Images.getImageWithErrorOverlay(base, "obj16/jar_obj.gif");
        }
        if (this.getMatchState() == UIDependencyElement.MatchState.UNKNOWN) {
            return Images.getImageWithNotFoundOverlay(base, "obj16/jar_obj.gif");
        }
        if (this.getMatchState() == UIDependencyElement.MatchState.SIMILAR) {
            return Images.getImageWithPartialMatchOverlay(base, "obj16/jar_obj.gif");
        }
        return Images.getImage(base);
    }

    @Override
    public ComparableVersion getUpdateVersion() {
        return this.updateVersion;
    }

    @Override
    public void setUpdateVersion(ComparableVersion version) {
        this.updateVersion = version;
    }

    @Override
    public Collection<IProject> getProjects() {
        return new HashSet<IProject>(this.projects);
    }

    @Override
    public boolean remove(IProject project) {
        boolean removed = this.projects.remove(project);
        if (removed) {
            this.resetTransitivity();
        }
        return removed;
    }

    @Override
    public boolean add(IProject project) {
        boolean firstProject = this.projects.isEmpty();
        boolean added = this.projects.add(project);
        if (added && (this.transitive || firstProject)) {
            this.resetTransitivity();
        }
        return added;
    }

    public String toString() {
        return this.key.getFile().toString();
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public void markAsLoaded() {
        this.loaded = true;
    }

    @Override
    public void setMatchState(UIDependencyElement.MatchState matchState) {
        this.matchState = matchState;
    }

    @Override
    public UIDependencyElement.MatchState getMatchState() {
        return this.matchState;
    }

    @Override
    public String getApplicationId() {
        return this.key.getAppId();
    }

    @Override
    public File getFileLocation() {
        return this.key.getFile();
    }

    @Override
    public void setError(int code, String message) {
        this.errorCode = code;
        this.errorMessage = message;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public Collection<PolicyAlert> getPolicyAlerts() {
        return this.alerts;
    }

    @Override
    public Integer getPolicyThreatLevel() {
        if (this.alerts == null) {
            return null;
        }
        int threatLevel = -1;
        for (PolicyAlert alert : this.alerts) {
            threatLevel = Math.max(threatLevel, alert.getTrigger().getThreatLevel());
        }
        return threatLevel;
    }

    @Override
    public void setPolicyAlerts(Collection<PolicyAlert> alerts) {
        this.alerts = alerts;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Override
    public void resetTransitivity() {
        if (this.transitiveDirty.compareAndSet(false, true)) {
            this.transitivityExecutor.process(new TransitivityRunnable());
        }
    }

    @Override
    public boolean isProprietary() {
        return this.proprietary;
    }

    @Override
    public void setProprietary(boolean proprietary) {
        this.proprietary = proprietary;
    }

    public static interface TransitivityProcessor {
        public void process(Runnable var1);

        public void update(UIDependencyElement var1);
    }

    private class TransitivityRunnable
    implements Runnable {
        private TransitivityRunnable() {
        }

        @Override
        public void run() {
            if (JavaDependencyElement.this.transitiveDirty.compareAndSet(true, false)) {
                JavaDependencyElement.this.transitive = MavenHelper.isTransitive(JavaDependencyElement.this);
                JavaDependencyElement.this.transitivityExecutor.update(JavaDependencyElement.this);
            }
        }
    }
}

