/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui.elements;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;

public class ProjectAssociation
implements Comparable<ProjectAssociation> {
    private String appId;
    private String appName;
    private Set<IProject> assignedProjects;

    public ProjectAssociation(String appId, String appName) {
        this.appId = appId;
        this.appName = appName;
        this.assignedProjects = new HashSet<IProject>();
    }

    @Override
    public int compareTo(ProjectAssociation o) {
        if (this.assignedProjects.isEmpty() != o.assignedProjects.isEmpty()) {
            return this.assignedProjects.isEmpty() ? 1 : -1;
        }
        if (this.appName == null || o.appName == null) {
            return this.appName == null ? (o.appName == null ? 0 : -1) : 1;
        }
        return this.appName.compareToIgnoreCase(o.getAppName());
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public Set<IProject> getAssignedProjects() {
        return this.assignedProjects;
    }

    public void setApplicationName(String appName) {
        this.appName = appName;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        if (this.appName == null) {
            buffer.append(this.appId);
        } else {
            buffer.append(this.appName);
        }
        if (!this.assignedProjects.isEmpty()) {
            buffer.append(" (").append(this.assignedProjects.size());
            buffer.append(this.assignedProjects.size() == 1 ? " project" : " projects").append(" assigned)");
        }
        if (this.appName == null) {
            buffer.append(" [Removed]");
        }
        return buffer.toString();
    }
}

