/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.update.ui;

import com.sonatype.clm.dto.model.policy.PolicyAlert;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.helpers.Severity;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UIComponentTooltip
extends Composite {
    private static final RGB[] BACKGROUND_COLORS = new RGB[]{UIComponentTooltip.createRGBfromColorCode("#bc012f"), UIComponentTooltip.createRGBfromColorCode("#f4861d"), UIComponentTooltip.createRGBfromColorCode("#f5c648"), UIComponentTooltip.createRGBfromColorCode("#006bbf"), UIComponentTooltip.createRGBfromColorCode("#97cbee")};
    private static final RGB[] FOREGROUND_COLORS = new RGB[]{UIComponentTooltip.createRGBfromColorCode("#dddddd"), UIComponentTooltip.createRGBfromColorCode("#dddddd"), UIComponentTooltip.createRGBfromColorCode("#000000"), UIComponentTooltip.createRGBfromColorCode("#dddddd"), UIComponentTooltip.createRGBfromColorCode("#dddddd")};
    private List<Color> colors = new ArrayList<Color>(4);

    private static RGB createRGBfromColorCode(String hexColorCode) {
        java.awt.Color awtColor = java.awt.Color.decode(hexColorCode);
        return new RGB(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
    }

    public UIComponentTooltip(Composite parent, int style, UIDependencyElement element) {
        super(parent, style);
        this.createLoadedTooltip(element);
    }

    private void createLoadedTooltip(UIDependencyElement element) {
        String status;
        GridLayout gl_parent = new GridLayout(1, false);
        gl_parent.verticalSpacing = 0;
        gl_parent.marginWidth = 0;
        gl_parent.marginHeight = 0;
        gl_parent.horizontalSpacing = 0;
        this.setLayout((Layout)gl_parent);
        Composite composite = new Composite((Composite)this, 0);
        composite.setBackground(this.getDisplay().getSystemColor(29));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label lblName = this.createLabel(composite);
        lblName.setText(Messages.UIComponentTooltip_nameLabel);
        Label lblname = this.createLabel(composite);
        lblname.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblname.setText(element.getName());
        if (element.getCurrentVersion() != null) {
            Label lblVersion = this.createLabel(composite);
            lblVersion.setText(Messages.UIComponentTooltip_versionLabel);
            Label lblversion = this.createLabel(composite);
            lblversion.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
            lblversion.setText(element.getCurrentVersion().toString());
        }
        Label lblInProjects = this.createLabel(composite);
        lblInProjects.setLayoutData((Object)new GridData(16384, 128, false, false));
        lblInProjects.setText(Messages.UIComponentTooltip_projectsLabel);
        String projectList = UIComponentTooltip.getProjectList(element);
        Label lblprojectList = this.createLabel(composite, 64);
        GC gc = new GC((Drawable)lblprojectList);
        int width = gc.textExtent((String)projectList).x;
        gc.dispose();
        GridData gd = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd.widthHint = Math.min(width + 20, 600);
        lblprojectList.setLayoutData((Object)gd);
        lblprojectList.setText(projectList);
        this.constructPolicyViolation(composite, element);
        if (element.isTransitive()) {
            Label labelTransitive = this.createLabel(composite);
            labelTransitive.setText(Messages.UIComponentTooltip_tooltipTransitive);
            labelTransitive.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        }
        if ((status = UIComponentTooltip.getStatus(element)) != null) {
            Label lblStatus = this.createLabel(composite);
            lblStatus.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
            lblStatus.setText(status);
        }
    }

    private static String getStatus(UIDependencyElement element) {
        if (element.isLoaded()) {
            if (element.getMatchState() == null) {
                return Messages.UIComponentTooltip_tooltipError;
            }
            if (element.getMatchState() == UIDependencyElement.MatchState.UNKNOWN) {
                return Messages.UIComponentTooltip_tooltipUnknownComponent;
            }
            if (element.getMatchState() == UIDependencyElement.MatchState.SIMILAR) {
                return Messages.UIComponentTooltip_tooltipPartialMatch;
            }
            return null;
        }
        return Messages.UIComponentTooltip_tooltipMatchingInProgress;
    }

    private void constructPolicyViolation(Composite parent, UIDependencyElement element) {
        if (!element.isLoaded()) {
            return;
        }
        Label lblPolicyViolations = this.createLabel(parent);
        lblPolicyViolations.setText(Messages.UIComponentTooltip_policyViolationLabel);
        lblPolicyViolations.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        if (element.getPolicyAlerts() == null || element.getPolicyAlerts().size() == 0) {
            Label noneLabel = this.createLabel(parent);
            noneLabel.setText(Messages.UIComponentTooltip_noPolicyAlerts);
            lblPolicyViolations.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        } else {
            Composite policyAlertComposite = new Composite(parent, 0);
            policyAlertComposite.setBackground(this.getDisplay().getSystemColor(29));
            policyAlertComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
            GridLayout layout = new GridLayout(4, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            policyAlertComposite.setLayout((Layout)layout);
            int[] buckets = new int[BACKGROUND_COLORS.length];
            for (PolicyAlert alert : element.getPolicyAlerts()) {
                Severity sev = Severity.getValue(alert.getTrigger().getThreatLevel());
                int n = sev.getValue();
                buckets[n] = buckets[n] + 1;
            }
            this.constructPolicyAlertRow(policyAlertComposite, Severity.CRITICAL, buckets);
            this.constructPolicyAlertRow(policyAlertComposite, Severity.SEVERE, buckets);
            this.constructPolicyAlertRow(policyAlertComposite, Severity.MODERATE, buckets);
            this.constructPolicyAlertRow(policyAlertComposite, Severity.LOW, buckets);
            this.constructPolicyAlertRow(policyAlertComposite, Severity.NONE, buckets);
        }
    }

    private void constructPolicyAlertRow(Composite parent, Severity severity, int[] buckets) {
        int index = severity.getValue();
        if (buckets[index] > 0) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 2;
            layout.marginWidth = 2;
            composite.setLayout((Layout)layout);
            Label lblSevereIcon = new Label(composite, 0);
            lblSevereIcon.setForeground(this.createColor(FOREGROUND_COLORS[index]));
            lblSevereIcon.setBackground(this.createColor(BACKGROUND_COLORS[index]));
            lblSevereIcon.setText(String.valueOf(buckets[index]));
            lblSevereIcon.setAlignment(0x1000000);
            GC gc = new GC((Drawable)lblSevereIcon);
            FontMetrics fontMetrics = gc.getFontMetrics();
            gc.dispose();
            lblSevereIcon.setSize(19, fontMetrics.getHeight() + 4);
            Double width = fontMetrics.getAverageCharacterWidth() * (double)(1 + lblSevereIcon.getText().length()) + 4.0;
            GridData data = new GridData(width.intValue(), fontMetrics.getHeight());
            lblSevereIcon.setLayoutData((Object)data);
        }
    }

    protected void checkSubclass() {
    }

    private static String getProjectList(UIDependencyElement element) {
        StringBuffer prjs = new StringBuffer();
        for (IProject prj : element.getProjects()) {
            prjs.append(prj.getName()).append(", ");
        }
        return prjs.substring(0, prjs.length() - 2).replace("&", "&&");
    }

    private Label createLabel(Composite parent) {
        return this.createLabel(parent, 0);
    }

    private Label createLabel(Composite parent, int style) {
        Label label = new Label(parent, style);
        label.setBackground(this.getDisplay().getSystemColor(29));
        label.setForeground(this.getDisplay().getSystemColor(28));
        return label;
    }

    private Color createColor(RGB rgb) {
        Color color = new Color((Device)this.getDisplay(), rgb);
        this.colors.add(color);
        return color;
    }

    public void dispose() {
        try {
            for (Color c : this.colors) {
                try {
                    c.dispose();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            super.dispose();
        }
    }
}

